import { _decorator, Component, Node, Prefab, SpriteComponent, instantiate, Scene, SkeletalAnimationComponent, Vec3, SkinningModelComponent, math, tween, LabelComponent } from "cc";
const { ccclass, property } = _decorator;

@ccclass("Manager")
export class Manager extends Component
{
    @property(Prefab)
    soldierPrefabs:Array<Prefab>=[];

    @property(Node)
    soldierNode:Node=null;

    // @property(Node)
    // plane1:Node=null;
    // @property(Node)
    // plane2:Node=null;
    // @property(Node)
    // plane3:Node=null;

    @property(SpriteComponent)
    touch:SpriteComponent=null;

    @property(Node)
    planes:Array<Node> = [];

    @property(LabelComponent)
    countLabel:LabelComponent=null;

    soldiers:Array<Node>=[]

    start()
    {
        cc.systemEvent.on(cc.SystemEventType.TOUCH_END,this.touchEnd,this);
    }

    touchEnd()
    {
        for (let i = 0; i < this.planes.length; i++)
        {
            let plane = this.planes[i];
            
            let node = instantiate(this.soldierPrefabs[i]) as Node;
            this.soldierNode.addChild(node);
            node.position = new Vec3(plane.position.x,0,plane.position.z);
            let sk = node.getComponent(SkeletalAnimationComponent)
            sk.play('idle');

            // let RootNode = node.getChildByName('RootNode')
            // let face = RootNode.getChildByName('polySurface212')
            // let pass = face.getComponent(SkinningModelComponent).material.passes[0]
            // pass.setUniform(pass.getHandle('albedo'),cc.v3(i==0?1:0,i==1?1:0,i==2?1:0))

            this.soldiers.push(node)
            
            let pos = new Vec3(math.random()*4-2,0,math.random()*4-2);
            
            this.scheduleOnce(()=>{
                node.position = pos;
            },0.5)
        }
    }

    update(dt)
    {
        this.countLabel.string = '场景兵数量 ' + this.soldiers.length
    }
}
