'use strict';
const path = require('path');
const fs = require('fs');

module.exports = {
    load() {
        // execute when package loaded


    },

    unload() {
        // execute when package unloaded
    },

    // register your ipc messages here
    messages: {
        'open'() {
            // open entry panel registered in package.json
            Editor.Panel.open('editor_setting');
        },
        'scene:ready'(){
            Editor.log('scene ready');
            const config_path = path.join(path.resolve('./'), 'editor_config.json');
            if (fs.existsSync(config_path)) {
                let config = fs.readFileSync(config_path);
                config = JSON.parse(config);
                //Editor.log('load()::cofing:', config);

                Editor.Scene.callSceneScript(
                    'editor_setting',
                    'set-font',
                    config
                );
            }
        }

    },
};