// panel/index.js, this filename needs to match the one registered in package.json
const path = require('path');
const fs = require('fs');
const project_path = Editor.Project.path;
const font_list = require(path.join(project_path,'packages/node_modules/font-list'));
Editor.Panel.extend({
  // css style for panel
  style: `
    :host { margin: 5px; font-size:18px; font-family:'Microsoft YaHei UI'}
    .input-group{
        display:flex;
        padding:2px 5px;
    }
   
    label{
        font-size:14px;
        font-weight:100;
        flex:1;
        min-width:80px;
        letter-spacing: 1px;
    }
    input,select{
        font-size:16px;
        flex:3;
        background-color:#333;
        color:#888;
        border:1px solid #333;
        -webkit-tap-highlight-color: #0000;
    }
    input {
        padding-left:0.2rem;
    }
    .reverse{
        flex-direction: row-reverse;
    }
  `,

  // html template for panel
  template: `
    <div class="input-group">
        <label for="font_size">字体大小</label>
        <input type="number" v-model="font_size" id="font_size"/>
    </div>
    <div class="input-group">
        <label for="font_family">字体</label>
        <select v-model="font_index" id="font_family">
            <option v-for="(index,fm) in fonts" value="{{index}}" :style="{'font-family':fm}">{{fm}}</option>
        </select>
    </div>
    <div class="input-group reverse">
        <ui-button id="save_btn" @click="save_config">保存</ui-button>
    </div>
    
  `,



  // method executed when template and styles are successfully loaded and initialized
   async ready () {
       const config_path = path.join(path.resolve('./'),'editor_config.json');
       const vm = new window.Vue({
           el: this.shadowRoot,
           data:{
               fonts : [],
               font_size:18,
               font_index:0,
           },
           computed:{
               font_family(){
                   return this.fonts[this.font_index];
               }
           },
           methods:{
               save_config(){
                   let config = {
                       font_size:this.font_size,
                       font_family:this.font_family,
                   };

                   Editor.Scene.callSceneScript(
                       'editor_setting',
                       'set-font',
                       config,
                   );
                   fs.writeFile(config_path,JSON.stringify(config));
               }

           },

       });

       let config = null;
       if(fs.existsSync(config_path)){
           config = fs.readFileSync(config_path);
           config = JSON.parse(config);
           vm.$set('font_size',config.font_size);
       }
       let fonts = await font_list.getFonts();
       fonts = fonts.map(item=>item.replace(/"(.+)"/,'$1'));
       vm.$set('fonts',fonts);
       if(config){
           for (let i = 0; i < fonts.length; i++) {
               let font_family = fonts[i];
               if(font_family === config.font_family){
                   vm.$set('font_index', i);
               }
           }
       }

  },



  // register your ipc messages here
  messages: {

  }
});