
(function () {
    Number.prototype.px = function () {
        return `${this}px`;
    };
})();

module.exports = {
    'set-font':function (e,{font_size,font_family}) {
        //const font_size = 18;
        //cc.log('set-font begin');
        font_size = parseInt(font_size);
        const tab_font_size = font_size * 14 / 18;
        const tab_height = tab_font_size* 1.8;
        let default_font_family = `${font_family},Microsoft YaHei UI`;



        // document 全局styleSheets
        for (let style_sheet of document.styleSheets) {
            for (let rule of style_sheet.rules) {
                if(rule.selectorText === 'body'){
                    rule.style.fontSize = font_size.px();
                }
                if(rule.selectorText === '#toolbar'){
                    rule.style.fontSize = font_size.px();
                    rule.style.height = `${1.5 * font_size}px`;
                    rule.style.lineHeight = `${1.5 * font_size}px`;
                }
                if(rule.selectorText === '#toolbar > .buttons'){
                    rule.style.padding = 0;
                    rule.style.paddingTop = '1px';
                    rule.style.paddingBottom = '2px';
                }
                if(rule.selectorText === '#toolbar > .buttons > div'){
                    rule.style.margin = 0;
                    rule.style.marginLeft = '3px';
                }
                //cc.log(style_sheet.href);
                if(rule.selectorText === '#toolbar > .preview'){
                    rule.style.margin = 0;
                    rule.style.padding = 0;
                    rule.style.paddingTop = '1px';
                    rule.style.paddingBottom = '2px';
                }
                if(rule.selectorText === '#toolbar > .preview > ui-select'){
                    rule.style.margin = 0;
                    rule.style.height = '100%';
                }
                if(rule.selectorText === '#toolbar > .preview > div'){
                    rule.style.margin = 0;
                    rule.style.marginLeft = '2px';
                    rule.style.alignItems = 'center';
                    rule.style.height = '100%';
                }
                if(rule.selectorText === '#toolbar > .preview > div > i'){
                    rule.style.padding = '0 1rem';
                    rule.style.lineHeight = '23px';
                    //rule.style.lineHeight = font_size.px();
                    //rule.style.height = '25px';
                }


            }
        }
        // region toolbar
        let rules = document.querySelector('ui-select').shadowRoot.styleSheets[0].rules;
        for (let rule of rules) {
            if(rule.selectorText === ':host'){
                rule.font_size = font_size.px();
            }
            if(rule.selectorText === 'select'){
                rule.style.border = 0;
                rule.style.fontSize = font_size.px();
                rule.style.paddingTop = 0;
                rule.style.paddingBottom = 0;
                rule.style.height = '100%';
            }
            if(rule.selectorText === ':host select'){
                rule.style.fontSize = `${font_size*0.8}px`;
                rule.style.lineHeight = font_size.px();
            }
        }
        // endregion

        // 第一级Shadow DOM,影响全局的CSS
        const ui_main_dock = document.querySelector('body > section > ui-main-dock').shadowRoot;
        const ui_main_dock_style_sheet = ui_main_dock.styleSheets[0];
        const host_style = ui_main_dock_style_sheet.rules[0].style;
        host_style.fontSize = font_size;
        host_style.fontFamily = default_font_family;
        host_style.fontWeight = 200;
        //host_style.letterSpacing = '0.1px';
        // ui-dock
        rules = document.querySelector('ui-main-dock ui-dock').shadowRoot.styleSheets[0].rules;
        const ui_dock_style = {
            host:rules[1].style,
        };
        ui_dock_style.host.fontSize = font_size.px();

        // dock-panel 层级管理器 场景编辑器 控件库 资源管理器 属性检测器 服务面板都是 dock-panel
        const ui_dock_panels = document.querySelectorAll('ui-dock-panel');
        for (let panel of ui_dock_panels) {
            // Tab group
            let tab_group = panel.shadowRoot.querySelector('#tabs');
            rules = tab_group.shadowRoot.styleSheets[0].rules;
            let tabs_style = {
                host:rules[1].style,
                host_icon: rules[2].style,
                tabs: rules[5].style
            };
            tabs_style.host.fontSize = tab_font_size.px();
            tabs_style.host_icon.fontSize = tab_font_size.px();
            tabs_style.tabs.height = tab_height.px();
            // Tab
            let tabs = tab_group.querySelectorAll('ui-dock-tab');
            for (let tab of tabs) {
                rules = tab.shadowRoot.styleSheets[0].rules;
                let tab_style = {
                    host:rules[0].style,
                    inner:rules[2].style,
                    title:rules[4].style,
                    icon_image:rules[6].style,
                    host_active:rules[7].style,
                    host_active_inner:rules[8].style,
                };
                tab_style.host.boxSizing = 'border-box';
                tab_style.host.height = tab_height.px();
                tab_style.host.fontSize = tab_font_size.px();
                tab_style.host.fontWeight = 100;
                tab_style.host.letterSpacing = '3px';
                tab_style.host.lineHeight = tab_height.px();
                tab_style.inner.height = tab_height.px();
                tab_style.title.height = tab_height.px();
                tab_style.host.fontFamily = default_font_family;
                tab_style.host_active.height = tab_height.px();
                tab_style.host_active_inner.height = tab_height.px();
            }

        }

        // region层级管理器
        const hierarchy = document.getElementById('hierarchy');
        rules = hierarchy.shadowRoot.styleSheets[1].rules;
        hierarchy.selector = {
            node_ul_li:rules[13].style,
            node_ul_li_input:rules[17].style
        };

        hierarchy.selector.node_ul_li.height = '';
        hierarchy.selector.node_ul_li_input.fontSize = font_size.px();
        hierarchy.selector.node_ul_li_input.fontFamily = default_font_family;
        // endregion

        // region 资源管理器
        const assets = document.getElementById('assets');
        rules = assets.shadowRoot.styleSheets[1].rules;
        assets.selector = {
            asset_icon:rules[49].style,
            node_ul_li_input:rules[14].style,
        };
        assets.selector.asset_icon.width = font_size.px();
        assets.selector.asset_icon.height = font_size.px();
        assets.selector.node_ul_li_input.fontSize = font_size.px();
        assets.selector.node_ul_li_input.fontFamily = default_font_family;
        // endregion

        // region 控台
        const console = document.getElementById('console');
        rules = console.shadowRoot.styleSheets[1].rules;

        for (let rule of rules) {
            if(rule.selectorText === '.item .warp'){
                rule.style.fontSize = font_size.px();
                rule.style.fontFamily = default_font_family;
            }
        }
        // endregion
    },
};



