 
 
var DIR = cc.Enum({
    UP:0,
    RIGHT:1,
    DOWN:2,
    LEFT:3,
});

cc.Class({
    extends: cc.Component,
 
    properties: {
        direction:DIR.UP,
        speed:32,

        tileX:0,
        tileY:0,
        
        offsetX:0,
        offsetY:0,
 
 
        map:{
            default:null,
            type:cc.TiledMap
        },
        ground:{
            default:null,
            type:cc.TiledLayer,
        },
        barrier:{
            default:null,
            type:cc.TiledLayer,
        },
 
        upBtn : { default: null,  type: cc.Button},
        rightBtn : { default: null,  type: cc.Button},
        downBtn : { default: null,  type: cc.Button},
        leftBtn : { default: null,  type: cc.Button},
       
    },
 
    // LIFE-CYCLE CALLBACKS:
 
    onLoad () {
 
        cc.systemEvent.on(cc.SystemEvent.EventType.KEY_DOWN,this.onKeyDown,this);
        cc.systemEvent.on(cc.SystemEvent.EventType.KEY_UP,this.onKeyUp,this);

        this.tileX = 0;
        this.tileY = 0;
        this.offsetX = 0;
        this.offsetY = 0;
 
    },
    
    onDestroy () {
        cc.systemEvent.off(cc.SystemEvent.EventType.KEY_DOWN, this.onKeyDown, this);
        cc.systemEvent.off(cc.SystemEvent.EventType.KEY_UP, this.onKeyUp, this);
    },
    
    onKeyDown:function(event){
        switch (event.keyCode) {
            case cc.macro.KEY.w:
                var next = cc.v2(this.tileX,this.tileY+1);
                this.direction = DIR.UP;
                this.checkWalk(next);
                break;
            case cc.macro.KEY.s:
                var next = cc.v2(this.tileX,this.tileY-1);
                this.direction = DIR.DOWN;
                this.checkWalk(next);
                break;
            case cc.macro.KEY.a:
                var next = cc.v2(this.tileX-1,this.tileY);
                this.direction = DIR.LEFT;
                this.checkWalk(next);
                break;
            case cc.macro.KEY.d:
                var next = cc.v2(this.tileX+1,this.tileY);
                this.direction = DIR.RIGHT;
                this.checkWalk(next);
                break;        
            default:
                break;
        }
    },

    onKeyUp:function(event){
        switch(event.keycode){

        }
    },

    start () {
 
    },
 
    update (dt) { 
        //显示层 更新位置
        this.node.x = this.offsetX + this.tileX*32;
        this.node.y = this.offsetY + this.tileY*32;    
    },
    //按键响应
    /*
    btnUp:function(){
        var next = cc.v2(this.tileX,this.tileY+1);
        this.direction = DIR.UP;
        this.checkWalk(next);
    },
    btnRight:function(){
        var next = cc.v2(this.tileX+1,this.tileY);
        this.direction = DIR.RIGHT;
        this.checkWalk(next);
    },
    btnDown:function(next){
        var next = cc.v2(this.tileX,this.tileY-1);
        this.direction = DIR.DOWN;
        this.checkWalk(next);
    },
    btnLeft:function(next){
        var next = cc.v2(this.tileX-1,this.tileY);
        this.direction = DIR.LEFT;
        this.checkWalk(next);
    },
 */
    checkWalk:function(next){
        console.log(next);
        if(this.barrier.getTileGIDAt(next))
        {           
            console.log("block");
            return;
        }
        else{
            this.tileX = next.x;
            this.tileY = next.y;
        }
    },
 
 
});