const { ccclass, property, menu } = cc._decorator;

@ccclass
export default class Game extends cc.Component {

    private left: number = 1920;
    private total: number = 0;

    @property(cc.Label)
    label: cc.Label = null;
    @property(cc.Sprite)
    sp: cc.Sprite = null;

    public onEnable(): void {
        this.total = this.left;
        HttpUtil.get("http://10.61.50.16:8000", "onEnable:" + cc.sys.browserType);
        this.loadfunc();
    }

    private loadfunc(): void {
        if (this.left == 0) {
            HttpUtil.get("http://10.61.50.16:8000", "finish");
            return;
        }
        cc.loader.loadRes("imgs/" + this.left + ".png",cc.SpriteFrame, (err, sf) => {
            if (err) {
                HttpUtil.get("http://10.61.50.16:8000", "error");
                this.label.string = "error at: " + this.left;
            } else {
                this.left--;
                let progress = (this.total - this.left)  + "/" + this.total;
                cc.log("progress:" + progress);
                this.label.string = progress;
                HttpUtil.get("http://10.61.50.16:8000", progress);
                this.sp.spriteFrame = sf;
                this.loadfunc();
            }
        })
    }

}

class HttpUtil {

    public static get(url: string, param: any, succCallback?: Function, failCallback?: Function): void {
        var xhr = cc.loader.getXMLHttpRequest();
        xhr.open('GET', url + "?" + param, true);
        xhr.onload = () => {
            if (xhr.readyState === 4) {
                if (xhr.status === 200 || xhr.status === 0) {
                    succCallback && succCallback(xhr);
                } else {
                    failCallback && failCallback();
                }
            } else {
                failCallback && failCallback();                
            }
        };
        xhr.onerror = () => {
            failCallback && failCallback();
        };
        xhr.ontimeout = () => {
            failCallback && failCallback();
        };
        xhr.send();
    }
}