const { ccclass, property, menu } = cc._decorator;
@ccclass
export default class Game extends cc.Component {
    @property(cc.Button)
    btn: cc.Button = null;
    @property(cc.Label)
	loading: cc.Label = null;
	
	status: Status = Status.None;

    public onEnable(): void {
        this.btn.node.on("click", this.onBtnClick, this);
		this.loading.node.active = false;
		this.setBtnText("clear");
    }

    private onBtnClick(): void {
		var self = this;
		if (self.status == Status.None || self.status == Status.ClearFail || self.status == Status.LoadFail
			|| self.status == Status.LoadSucc) {
			self.loading.node.active = true;
			self.status = Status.Clearing;
			
			self.loading.string = "clearing";
			cc.loader.releaseResDir("datu");
			if (window['wxDownloader']) {
				window['wxDownloader'].cleanOldAssets(function() {
					self.loading.string = "clear succ";
					self.status = Status.ClearSucc;
					self.setBtnText("load");
				},
				function() {
					self.loading.string = "clear fail";
					self.status = Status.ClearFail;
					self.setBtnText("clear");
				});
			} else {
				self.status = Status.ClearSucc;
				self.loading.string = "clear succ";
				self.setBtnText("load");
			}
		} else if (self.status == Status.ClearSucc) {
			self.status = Status.Loading;
			cc.loader.loadResDir("datu", cc.SpriteFrame, function(completedCount, totalCount, item) {
			self.loading.string = completedCount + "/" + totalCount;
				console.log("load progress: " + completedCount + "/" + totalCount); 
			},function(error1, resource1) {
				if (error1) {
					self.loading.string = "load failed";
					self.status = Status.LoadFail;
					self.setBtnText("clear");
				} else {
					self.loading.string = "load success";
					self.status = Status.LoadSucc;
					self.setBtnText("clear");
				}
				console.log("load folder finish");
			});
		}
	}
	
	private setBtnText(text: string): void {
		this.btn.getComponentInChildren(cc.Label).string = text;
	}
}

enum Status {
	None,
	Clearing,
	ClearFail,
	ClearSucc,
	Loading,
	LoadSucc,
	LoadFail
}