
cc.Class({
    extends: cc.Component,

    properties: {
        nodeImage : cc.Node,
        btnCapture : cc.Node,
    },

    onLoad() {
        this.finalTexture;
    },

    capture1() {
        cc.log("capture1()");
        let data = this.nodeToArray1(this.nodeImage);
        // this.checkData(data);
    },

    capture2() {
        cc.log("capture2()");
        let that = this;
        var image = new Image();
        image.onload = function () {
            cc.log("image.onload()");

            let data = that.imgToArray(image);
            that.checkData(data);
            image = null;
        };
        image.onerror = function () {
            cc.log("image.onerror() ！！！");
        };
        // image.src = "http://localhost:8081/%E4%B8%80%E4%BA%9B%E5%9B%BE/img.jpg";
        image.src = "https://desk-fd.zol-img.com.cn/t_s960x600c5/g5/M00/0F/09/ChMkJlauze2IPKICABzBh_ueXY0AAH9JAMQ2qUAHMGf334.jpg";
        cc.log("image.src =", image.src);
    },

    nodeToArray1(node) {
        cc.log("nodeToArray1()");

        node.x = -cc.winSize.height;
        node.y = -cc.winSize.height;

        node.name = "GET_TEXTURE_ARR_NODE";
        node.parent = cc.director.getScene();

        var camera = node.getComponent(cc.Camera);
        if(camera == null) {
            camera = node.addComponent(cc.Camera);
            camera.cullingMask = 0xffffffff;
            var texture = new cc.RenderTexture();
            var gl = cc.game._renderContext;
            texture.initWithSize(node.width, node.height, gl.STENCIL_INDEX8);  //  STENCIL_INDEX8 DEPTH_STENCIL
            camera.targetTexture = texture;
        }
        camera.render();

        this.finalTexture = camera.targetTexture;

        setTimeout(function () {
            let data = this.textureToArray(this.finalTexture);
            this.checkData(data);
        }.bind(this), 1000);

        // this.checkData(data);
    },

    textureToArray(texture) {
        console.log("textureToArray()");
        var data = texture.readPixels();

        // camera.render();
        // var texture = camera.targetTexture;
        // var data = texture.readPixels();

        var newData = new Uint8Array(data.length);
        for(var i=0; i<texture.height; i++) {
            for(var j=0; j<texture.width*4; j++) {
                newData[i * texture.width *4 + j] = data[(texture.height - i - 1) * texture.width * 4 + j];
            }
        }
        return newData;
    },

    imgToArray(image) {
        cc.log("imgToArray()");
        try {
            var canvas = document.createElement('canvas');
            canvas.width = image.width;
            canvas.height = image.height;

            cc.log("  canvas.size =", canvas.width, canvas.height);
            var context = canvas.getContext('2d');
            context.drawImage(image, 0, 0, image.width, image.height);

            context.drawImage(image, 100, 100, image.width - 200, image.height - 200);

            var imageData = context.getImageData(0, 0, canvas.width, canvas.height).data;
            cc.log("  imageData.length =", imageData.length);

            // IOS微信版大约需要2秒来复制数组
            // Now you can access pixel data from imageData.data.
            // It's a one-dimensional array of RGBA values.
            var aryData = new Uint8Array(imageData.length);
            for (var i = 0; i < imageData.length; i++) {
                aryData[i] = imageData[i];
            }

            canvas = null;

            return aryData;
        } catch (e) {
            cc.log(e);
            return null;
        }
    },

    checkData(data) {
        let nSumRGB = 0;
        let nSumA = 0;

        for (let i = 0; i < data.length; i += 4) {
            nSumRGB += (data[i] + data[i + 1] + data[i + 2]);
            nSumA += data[i + 3];

            if (i < 500) {
                cc.log(" ", data[i], data[i + 1], data[i + 2],  data[i + 3]);
            }
        }

        cc.log("Avg RGB =", nSumRGB / data.length * 4 / 3);
        cc.log("Avg A =", nSumA / data.length * 4);
    }
});
