(function() {"use strict";var __module = CC_EDITOR ? module : {exports:{}};var __filename = 'preview-scripts/assets/scene/begin2/begin2.js';var __require = CC_EDITOR ? function (request) {return cc.require(request, require);} : function (request) {return cc.require(request, __filename);};function __define (exports, require, module) {"use strict";
cc._RF.push(module, '949daodspdOWoBLySx8FVNz', 'begin2', __filename);
// scene/begin2/begin2.js

'use strict';

cc.Class({
    extends: cc.Component,

    properties: {
        donatePart: {
            type: cc.Node,
            default: []
        },
        storyLabel: {
            type: cc.Label,
            default: []
        },
        storyLimit: {
            type: cc.RichText,
            default: null
        },
        moneyLabel: {
            type: cc.Label,
            default: []
        },
        moneyLimit: {
            type: cc.RichText,
            default: null
        },
        ani: {
            type: cc.Animation,
            default: null
        },
        maxName: 34,
        ctx: cc.JsonAsset
    },
    onLoad: function onLoad() {
        //这个场景内存占用非常高，而且不会减少。
        //显示的名字数：如果这个数字调高，模拟器必出现闪退
        this.showCount = window.showCount;

        this.ctx = this.ctx.json;
        this.refreshUI();
        this.ani.play();
    },
    refreshUI: function refreshUI() {
        var str = ["", ""];
        var side = 0;
        var list = this.ctx.staff.story;
        for (var i = 0; i < list.length; i++) {
            str[side] += list[i] + "\n";
            if (side === 0) side = 1;else side = 0;
            if (i >= this.showCount) {
                this.storyLimit.node.active = true;
                this.storyLimit.string = "等<color=#ffffff>" + (list.length - i - 1) + "</c>位";
                break;
            }
        }
        this.storyLabel[0].string = str[0];
        this.storyLabel[1].string = str[1];

        str = ["", ""];
        side = 0;
        list = this.ctx.staff.money;
        for (var i = 0; i < list.length; i++) {
            str[side] += list[i].name + "\n";
            if (side === 0) side = 1;else side = 0;
            if (i >= this.showCount) {
                this.moneyLimit.node.active = true;
                this.moneyLimit.string = "等<color=#ffffff>" + (list.length - i - 1) + "</c>位";
                break;
            }
        }
        this.moneyLabel[0].string = str[0];
        this.moneyLabel[1].string = str[1];
    },
    aniOver: function aniOver() {
        cc.director.loadScene("scene/begin1/begin1");
    }
});

cc._RF.pop();
        }
        if (CC_EDITOR) {
            __define(__module.exports, __require, __module);
        }
        else {
            cc.registerModuleFunc(__filename, function () {
                __define(__module.exports, __require, __module);
            });
        }
        })();
        //# sourceMappingURL=begin2.js.map
        