const resources = [
    "https://7761-wangxing-1989-183b75-1302282572.tcb.qcloud.la/dragonbones/test/5.5/Dragon_ske.json",
    "https://7761-wangxing-1989-183b75-1302282572.tcb.qcloud.la/dragonbones/test/5.5/Dragon_tex.json",
    "https://7761-wangxing-1989-183b75-1302282572.tcb.qcloud.la/dragonbones/test/5.5/Dragon_tex.png",
];

cc.Class({
    extends: cc.Component,

    ctor() {
        this.index = 0;
        this.curResUrl = null;

        this.skeJson = null;
        this.texJson = null;
        this.texPng = null;
    },

    properties: {
        dragon: cc.Node
    },

    start() {
        this.loadRes();
    },

    loadRes() {
        this.curResUrl = resources[this.index];
        cc.assetManager.loadRemote(this.curResUrl, (err, assets) => {
            this.jiexi(this.curResUrl, assets);
            if (this.index < resources.length - 1) {
                this.index++;
                this.loadRes();
            } else {
                this.play();
            }
        });
    },

    analysis(url, assets) {
        if (url.split("_")[1] == "ske.json") {
            this.skeJson = assets;
        } else if (url.split("_")[1] == "tex.json") {
            this.texJson = assets;
        } else if (url.split("_")[1] == "tex.png") {
            this.texPng = assets;
        }
    },

    play(){
        let node = new cc.Node("newNode");
        let dragonBonesNode = node.addComponent(dragonBones.ArmatureDisplay);
        let _dragonAsset = new dragonBones.DragonBonesAsset();
        _dragonAsset.dragonBonesJson = JSON.stringify(this.skeJson);
        let _dragonAtlasAsset = new dragonBones.DragonBonesAtlasAsset();
        _dragonAtlasAsset.atlasJson = JSON.stringify(this.texJson);
        _dragonAtlasAsset.texture = this.texPng;

        dragonBonesNode.dragonAsset = _dragonAsset;
        dragonBonesNode.dragonAtlasAsset = _dragonAtlasAsset;
        dragonBonesNode.buildArmature('Dragon', node);
        dragonBonesNode.playAnimation('stand', 0);
        this.dragon.addChild(node);
    },
});
