"use strict";
cc._RF.push(module, '1ff93uwD7FGvYvdQczxRThu', 'Main');
// src/Main.js

"use strict";

var resources = ["https://7761-wangxing-1989-183b75-1302282572.tcb.qcloud.la/dragonbones/test/5.5/Dragon_ske.json", "https://7761-wangxing-1989-183b75-1302282572.tcb.qcloud.la/dragonbones/test/5.5/Dragon_tex.json", "https://7761-wangxing-1989-183b75-1302282572.tcb.qcloud.la/dragonbones/test/5.5/Dragon_tex.png"];
cc.Class({
  "extends": cc.Component,
  ctor: function ctor() {
    this.index = 0;
    this.curResUrl = null;
    this.skeJson = null;
    this.texJson = null;
    this.texPng = null;
  },
  properties: {
    dragon: cc.Node
  },
  start: function start() {
    this.loadRes();
  },
  loadRes: function loadRes() {
    var _this = this;

    this.curResUrl = resources[this.index];
    cc.assetManager.loadRemote(this.curResUrl, function (err, assets) {
      _this.jiexi(_this.curResUrl, assets);

      if (_this.index < resources.length - 1) {
        _this.index++;

        _this.loadRes();
      } else {
        _this.play();
      }
    });
  },
  analysis: function analysis(url, assets) {
    if (url.split("_")[1] == "ske.json") {
      this.skeJson = assets;
    } else if (url.split("_")[1] == "tex.json") {
      this.texJson = assets;
    } else if (url.split("_")[1] == "tex.png") {
      this.texPng = assets;
    }
  },
  play: function play() {
    var node = new cc.Node("newNode");
    var dragonBonesNode = node.addComponent(dragonBones.ArmatureDisplay);

    var _dragonAsset = new dragonBones.DragonBonesAsset();

    _dragonAsset.dragonBonesJson = JSON.stringify(this.skeJson);

    var _dragonAtlasAsset = new dragonBones.DragonBonesAtlasAsset();

    _dragonAtlasAsset.atlasJson = JSON.stringify(this.texJson);
    _dragonAtlasAsset.texture = this.texPng;
    dragonBonesNode.dragonAsset = _dragonAsset;
    dragonBonesNode.dragonAtlasAsset = _dragonAtlasAsset;
    dragonBonesNode.buildArmature('Dragon', node);
    dragonBonesNode.playAnimation('stand', 0);
    this.dragon.addChild(node);
  }
});

cc._RF.pop();