import { _decorator, Component, Node, CanvasComponent, loader, SpriteFrame } from "cc";
const { ccclass, property } = _decorator;

@ccclass("GameCanvas")
export class GameCanvas extends CanvasComponent {    
    
    private myCanvas;
    private context;

    onLoad(){
        this.myCanvas = document.createElement('canvas');
        this.context = this.myCanvas.getContext('2d');
    }

    start () {
        // Your initialization goes here.
    }

    //获取指定图片文件的像素数据。返回Promise
    //path写到文件名就行，不需要加spriteFrame和后缀
    loadImagePixelData(path:string){
        var self = this
        return new Promise((resolve,reject)=>{
            loader.loadRes(path+"/spriteFrame",SpriteFrame,(err,res)=>{
                if(err){
                    console.error(err)
                    return reject();
                }
                var spriteFrame = <SpriteFrame>res;
                var rect = spriteFrame.rect;
                var img = new Image();
                img.src = spriteFrame.texture.image.nativeUrl;
                // console.log(spriteFrame._image.nativeUrl);
                // console.log(spriteFrame._image.url);
                img.onload=()=>{                
                    self.context.drawImage(img,0,0,rect.width,rect.height);
                    var imageData = self.context.getImageData(0,0,rect.width,rect.height);
                    resolve(imageData);
                }
                img.onerror=()=>{
                    reject("Error:load img failed!Path="+path);
                }
            })
        });
    }

    // update (deltaTime: number) {
    //     // Your update function goes here.
    // }
}
