import { _decorator, Component, Node, Vec2, Vec3, UITransformComponent } from "cc";
const { ccclass, property } = _decorator;

@ccclass("Ground")
export class Ground extends Component {

    @property
    gridLen:number=1;

    private lenX:number=0;
    private lenZ:number=0;

    private _distances=[];
    private _mapOpt:IMapOption;
    get mapOption():IMapOption{
        return this._mapOpt;
    }

    onLoad(){

    }
    

    start () {
        
    }

    //需要通过外界使用canvas获得地图数据
    initSdfSys(opt:IMapOption){
        this._mapOpt=opt;
        var gridCountH = this._mapOpt.gridCountH;
        var gridCountV = this._mapOpt.gridCountV;
        this.lenX = gridCountH*this.gridLen;
        this.lenZ = gridCountV*this.gridLen;
        this._distances=[];
        for(let i=0;i<gridCountV+1;i++){
            let dataArr = [];
            for(let j=0;j<gridCountH+1;j++){
                var value=0;
                dataArr.push(value);
            }
            this._distances.push(dataArr);
        }
        this.refreshData();        
    }

    //刷新数据
    private refreshData(){
        for(let z=0;z<this._distances.length;z++){
            for(let x=0;x<this._distances[z].length;x++){
                var dis = this._distances[z][x];
                var newDis = this._checkDis(x,z);
                if(newDis!=dis){
                    this._distances[z][x] = newDis;
                }
            }
        }
    }
    //距离检测
    private _checkDis(vertX:number,vertZ:number):number{
        var result;
        var blockData = this._mapOpt.blockData;
        var gridLen = this.gridLen;
        for(let z=0;z<blockData.length;z++){
            for(let x=0;x<blockData[z].length;x++){
                if(blockData[z][x]){
                    let dis;
                    if(z>=vertZ&&x>=vertX){
                        dis = gridLen*(Math.sqrt(Math.pow(z-vertZ,2)+Math.pow(x-vertX,2)));
                    }
                    else if(z<vertZ&&x>=vertX){
                        dis = gridLen*(Math.sqrt(Math.pow(z-vertZ+1,2)+Math.pow(x-vertX,2)));
                    }
                    else if(z>=vertZ&&x<vertX){
                        dis = gridLen*(Math.sqrt(Math.pow(z-vertZ,2)+Math.pow(x-vertX+1,2)));
                    }
                    else if(z<vertZ&&x<vertX){
                        dis = gridLen*(Math.sqrt(Math.pow(z-vertZ+1,2)+Math.pow(x-vertX+1,2)));
                    }
                    if(isNaN(result)||dis<result) result=dis;
                }
            }
        }
        return result||0; 
    }

    calPointDis(pos:Vec3){
        var blockData = this._mapOpt.blockData;
        var gridLen = this.gridLen;
        var gridPos = this.nodePos2GridPos(pos);
        if(blockData[gridPos.y]&&blockData[gridPos.y][gridPos.x]) return 0;
        var posZero = this.vertexPos2NodePos(gridPos.x,gridPos.y);
        var parmX = (pos.x-posZero.x)/gridLen;
        var parmY = (pos.z-posZero.z)/gridLen;
        var dis_lt = this._distances[gridPos.y+1][gridPos.x];
        var dis_ld = this._distances[gridPos.y][gridPos.x];
        var dis_rt = this._distances[gridPos.y+1][gridPos.x+1];
        var dis_rd = this._distances[gridPos.y][gridPos.x+1];
        var dis = (1-parmX)*(1-parmY)*dis_ld+parmX*(1-parmY)*dis_rd+(1-parmX)*parmY*dis_lt+parmX*parmY*dis_rt;
        return dis;
    }

    //求任意点的梯度方向
    calGradient(pos:Vec3):Vec3{
        var delta=1;
        var dis0 = this.calPointDis(new Vec3(pos.x+delta,0,pos.z));
        var dis1 = this.calPointDis(new Vec3(pos.x-delta,0,pos.z));
        var dis2 = this.calPointDis(new Vec3(pos.x,0,pos.z+delta));
        var dis3 = this.calPointDis(new Vec3(pos.x,0,pos.z-delta));
        var result = new Vec3(dis0-dis1,0,dis2-dis3).multiplyScalar(0.5);
        //console.log(StringUtils.format("dis0=%s,dis1=%s,dis2=%s,dis3=%s,result=%s",dis0,dis1,dis2,dis3,result));
        return result;
    }

    nodePos2GridPos(pos:Vec3):Vec2{
        var width = this.lenX;
        var height = this.lenZ;
        var x = Math.floor((width/2+pos.x)/this.gridLen);
        var z = Math.floor((height/2+pos.z)/this.gridLen);
        return new Vec2(x,z);
    }
    gridPos2NodePos(gridX,gridZ):Vec3{
        var width = this.lenX;
        var height = this.lenZ;
        return new Vec3(this.gridLen*(gridX+0.5)-width/2,0,this.gridLen*(gridZ+0.5)-height/2);
    }
    vertexPos2NodePos(vX,vZ):Vec3{
        var width = this.lenX;
        var height = this.lenZ;
        return new Vec3(this.gridLen*vX-width/2,0,this.gridLen*vZ-height/2);
    }
}


export interface IMapOption{
    gridCountH:number;
    gridCountV:number;
    blockData:Array<Array<boolean>>;
}