import { _decorator, Component, Node, CameraComponent, Vec3, Quat } from "cc";
import { Ground } from "./Ground";
import { SimulateJoystick } from "./SimulateJoystick";
const { ccclass, property } = _decorator;

@ccclass("Player")
export class Player extends Component {

    @property
    speed:number=2;
    protected _speedRatio:number=1;
    get curSpeed():number{
        return this.speed*this._speedRatio;
    }

    get collideRaduis(){
        return 1;
    }

    protected _ground:Ground;
    protected _joystick:SimulateJoystick=null;

    //是否由摇杆操纵。摇杆模式下角色会持续移动，通过speedRatio值来控制速度
    protected _isControlledByJoystick:boolean=false;

    start () {
        // Your initialization goes here.
    }


    setJoystick(joystick:SimulateJoystick){
        this._joystick = joystick;
    }
    setGround(ground:Ground){
        this._ground = ground;
    }

    setSpeedRatio(ratio:number){
        this._speedRatio=ratio;
    }


    update (deltaTime: number) {
        if(this._joystick){
            this.setSpeedRatio(this._joystick.exportSpeedRatio);
            if(this._speedRatio){
                var curPos = this.node.position.clone();
                var moveDis_dt = this.curSpeed*deltaTime;
                var dir = this._joystick.exportDir;
                var newPos = curPos.clone().add(dir.clone().multiplyScalar(moveDis_dt));
                var sd = this._ground.calPointDis(newPos);
                if(sd<this.collideRaduis){
                    //console.log("sd=",sd);
                    var gradient = this._ground.calGradient(newPos);
                    var adjustDir = dir.clone().subtract(gradient.clone().multiplyScalar(Vec3.dot(gradient,dir)))
                    newPos = curPos.clone().add(adjustDir.normalize().multiplyScalar(moveDis_dt));
                    for(var i=0;i<3;i++){
                        sd = this._ground.calPointDis(newPos);
                        if(sd>=this.collideRaduis) break;
                        newPos.add(this._ground.calGradient(newPos.clone()).multiplyScalar(this.collideRaduis-sd));
                    }
                    //避免往返
                    if(Vec3.dot(newPos.clone().subtract(curPos),dir.clone())<0){
                        newPos = curPos;
                    }
                }
                this.node.setPosition(newPos);
            }
        }
    }
}
