import { _decorator, Component, Node, CameraComponent, Vec2, EventTouch, Quat, Vec3, UITransformComponent, director } from "cc";
import { Player } from "./Player";
const { ccclass, property } = _decorator;

const JOYSTICK_MOVEDIS_MAX=200;
const JOYSTICK_MOVEDIS_SPEEDMAX=100;
@ccclass("SimulateJoystick")
export class SimulateJoystick extends Component {
    @property(UITransformComponent)
    arrow:UITransformComponent=null;

    private _joystickCenter:Vec2=new Vec2;

    private _exportDir:Vec3;
    get exportDir(){
        return this._exportDir;
    }
    private _exportSpeedRatio=0;
    get exportSpeedRatio(){
        return this._exportSpeedRatio;
    }

    onLoad(){
        this.arrow.node.active=false;
    }

    start () {
        this.node.on(Node.EventType.TOUCH_START,this._on_touch_start,this);
        this.node.on(Node.EventType.TOUCH_MOVE,this._on_touch_move,this);
        this.node.on(Node.EventType.TOUCH_END,this._on_touch_end,this);
        this.node.on(Node.EventType.TOUCH_CANCEL,this._on_touch_end,this);
    }

    private _on_touch_start(e:EventTouch){
        this._joystickCenter = e.getUILocation();
        var viewSize = director.getWinSize();
        this.arrow.node.setPosition(new Vec3(this._joystickCenter.x-viewSize.width/2,this._joystickCenter.y-viewSize.height/2,0));
    }

    private _on_touch_move(e:EventTouch){
        var pos = e.getUILocation();
        var dis = this.calDistanceOfPoints_vec2(this._joystickCenter,pos);
        if(dis>JOYSTICK_MOVEDIS_MAX){
            dis = JOYSTICK_MOVEDIS_MAX;
        }
        var speedRatio = dis<JOYSTICK_MOVEDIS_SPEEDMAX?dis/JOYSTICK_MOVEDIS_SPEEDMAX:1;
        this._exportSpeedRatio=speedRatio;
        //方向        
        var radianUi = Math.atan2(pos.y-this._joystickCenter.y,pos.x-this._joystickCenter.x);
        var degreeUi = radianUi*180/Math.PI-90;
        var degree = degreeUi+45;
        var newRo = new Quat();
        Quat.fromEuler(newRo,0,degree,0);
        var dirRadian = (degree+90)*Math.PI/180;
        this._exportDir=new Vec3(Math.cos(dirRadian),0,-Math.sin(dirRadian));
        //箭头
        var newUiRo = new Quat();
        Quat.fromEuler(newUiRo,0,0,degreeUi);
        this.arrow.node.active=true;
        this.arrow.height = dis;
        this.arrow.node.setRotation(newUiRo);
    }

    private _on_touch_end(e:EventTouch){
        this._exportSpeedRatio=0;
        this.arrow.node.active=false;
    }

    private calDistanceOfPoints_vec2(p1:Vec2,p2:Vec2){        
        return Math.sqrt(Math.pow(p2.x-p1.x,2)+Math.pow(p2.y-p1.y,2));
    }
    
    // update (deltaTime: number) {
    //     // Your update function goes here.
    // }
}
