import { _decorator, Component, Node, CameraComponent, Vec3 } from 'cc';
import { Player } from './Player';
import { SimulateJoystick } from './SimulateJoystick';
import { Ground, IMapOption } from './Ground';
import { GameCanvas } from './GameCanvas';
const { ccclass, property } = _decorator;

@ccclass('StageScene')
export class StageScene extends Component {
    @property(CameraComponent)
    camera:CameraComponent=null;
    @property(GameCanvas)
    canvas:GameCanvas=null;
    @property(Ground)
    ground:Ground=null;
    @property(Player)
    player:Player=null;
    @property(SimulateJoystick)
    joystick:SimulateJoystick=null;
    @property(Node)
    loading:Node=null;

    start () {
        this.loading.active=true;
        this.player.setGround(this.ground);
        this.player.node.setPosition(new Vec3(-1.7,0,3.8));
        this.joystick.node.active=false;
        this.initGround(this.canvas).then(()=>{
            this.player.setJoystick(this.joystick);
            this.joystick.node.active=true;
            this.loading.active=false;
        })
    }

    //返回Promise
    initGround(canvas:GameCanvas){
        var self = this;        
        var path = "HeightMap";
        return new Promise((resolve,reject)=>{
            self.canvas.loadImagePixelData(path).then((data:any)=>{
                var blockData = self.imgData2PassData(data);
                //console.log(passData);
                var mapOpt:IMapOption={
                    gridCountH:data.width,
                    gridCountV:data.height,
                    blockData:blockData
                }
                this.ground.initSdfSys(mapOpt);
                resolve();
            })
        });
    }

    //高度图数据转化为地图通行数据
    //imgData格式：{data:Uint8ClampedArray,width:number,height:number}
    imgData2PassData(imgData:any){
        var data = imgData.data;
        var result = [];
        var width = imgData.width;
        var height = imgData.height;
        if(data.length<width*height*4){
            console.error("Error:图片数据长度不足！")
            return [];
        }
        var count = 0;
        for(var y=0;y<height;y++){
            var arr = [];
            for(var x=0;x<width;x++){
                var r = data[count];
                var g = data[count+1];
                var b = data[count+2];
                arr.push(r<128&&g<128&&b<128);
                count+=4;
            }
            result.push(arr);
        }
        return result;
    }

    update (deltaTime: number) {
        this.camera.node.setPosition(this.player.node.position.clone().add(new Vec3(9.3,18.2,9.4)));
    }
}
