import MyGlobal from "./MyGlobal";

const {ccclass, property} = cc._decorator;

@ccclass
export default class DragonNode extends cc.Component {

    playDragon(path){
        cc.resources.loadDir(path,(error,assets:any)=>{
            if(error)return;
            if (cc.isValid(this.node)) {
                let dragonDisplay = this.node.getComponent(dragonBones.ArmatureDisplay);
                if (assets instanceof Array && assets.length > 0){
                    for (let index = 0; index < assets.length; index++) {
                        if (assets[index] instanceof dragonBones.DragonBonesAsset){
                            dragonDisplay.dragonAsset = assets[index]
                        }else if(assets[index] instanceof dragonBones.DragonBonesAtlasAsset){
                            dragonDisplay.dragonAtlasAsset = assets[index]
                        }
                    }
                    dragonDisplay.armatureName = "Armature";
                    dragonDisplay.setAnimationCacheMode(dragonBones.ArmatureDisplay.AnimationCacheMode.SHARED_CACHE);
                    dragonDisplay.playAnimation("newAnimation",1);
                    dragonDisplay.removeEventListener(dragonBones.EventObject.LOOP_COMPLETE);
                    dragonDisplay.addEventListener(dragonBones.EventObject.LOOP_COMPLETE,()=>{
                        MyGlobal.GameManager.putDragonNode(this.node);
                    },this)
                }
            }
        })
    }
}