import DragonNode from "./DragonNode";
import MyGlobal from "./MyGlobal";

const {ccclass, property} = cc._decorator;

@ccclass
export default class Helloworld extends cc.Component {

    @property(cc.Label)
    label: cc.Label = null;

    @property
    text: string = 'hello';

    @property(cc.Prefab)
    dragonPrefab:cc.Prefab = null;

    private dragonNodePool = new cc.NodePool();
    start () {
        // init logic
        this.label.string = this.text;
    }

    onLoad(){
        MyGlobal.GameManager = this;
    }

    getDragonNode(){
        let dragonNode:cc.Node = null;
        if (this.dragonNodePool.size() > 0) {
            dragonNode = this.dragonNodePool.get()
        }else{
            dragonNode = cc.instantiate(this.dragonPrefab);
        }
        return dragonNode;
    }

    putDragonNode(node:cc.Node){
        this.dragonNodePool.put(node);
    }

    onPlayAClick(){
        let dragonNode = this.getDragonNode();
        dragonNode.parent = this.node;
        dragonNode.getComponent(DragonNode).playDragon("big_gold");
    }

    onPlayBClick(){
        let dragonNode = this.getDragonNode();
        dragonNode.parent = this.node;
        dragonNode.getComponent(DragonNode).playDragon("big_silver");
    }
}
