
const { ccclass, property } = cc._decorator;

@ccclass
export default class RectGlow extends cc.Component {

    _progress: number = 0;
    @property
    get progress(): number { return this._progress; }
    set progress(value) {
        this._progress = value;
        this.refreshMaterial();
    }

    _sprite: cc.Sprite = null;

    setSize(w: number, h: number) {
        if (this._sprite == null) this._sprite = this.node.getComponent(cc.Sprite);
        let material = this._sprite.getMaterial(0);
        if (material && material.effectAsset.name == 'draw_rect_glow') {
            material.setProperty('u_rect', [w, h]);
        }
    }

    refreshMaterial() {
        if (this._sprite == null) this._sprite = this.node.getComponent(cc.Sprite);
        let material = this._sprite.getMaterial(0);
        if (material && material.effectAsset.name == 'draw_rect_glow') {
            material.setProperty('u_progress', this.progress);
            this._sprite.setMaterial(0, material);
        }
    }
}
