const {ccclass, property} = cc._decorator;

@ccclass
export default class Helloworld extends cc.Component {

    @property(cc.Label)
    label: cc.Label = null;

    @property
    text: string = 'hello';

    @property(cc.WheelJoint)
    joint:cc.WheelJoint = null;

    onLoad(){
        let pm:cc.PhysicsManager = cc.director.getPhysicsManager();
        pm.enabled = true;
        pm.debugDrawFlags = cc.PhysicsManager.DrawBits.e_aabbBit | 
            cc.PhysicsManager.DrawBits.e_jointBit | 
            cc.PhysicsManager.DrawBits.e_shapeBit;
        
        // init logic
        this.label.string = this.text;
    };

    start () {
        this.joint.frequency = 20;

    };

    update(dt){
        // this.joint.frequency = 30;
    };
}
