cc.Class({
    extends: cc.Component,

    properties: {
        itemTemplate: { //item template to instantiate other items
            default: null,
            type: cc.Prefab
        },
        scrollView: {
            default: null,
            type: cc.ScrollView
        },
        spawnCount: 0, // how many items we actually spawn
        spacing: 0, // space between each item
        bufferZone: 0, // when item is away from bufferZone, we relocate it
        itemScale: 1, // item scale
    },

    // use this for initialization
    onLoad: function() {
        this._init();
    },

    _init: function() {
        if (!this.hasInitEx) {
            this.content = this.scrollView.content;
            this.items = []; // array to store spawned items
            this.totalCount = 0;
            this.updateTimer = 0;
            this.offsetIndex = 0;
            this.updateInterval = 0.2;
            this.ItemInfoList = [];
            this.scrollOffsetDifferenceValue = 0;
            this.initItemCount = 0;
            this.initItemCurrentIndex = 0;
            this.bSplitLoading = true; //分帧加载
            this.lastContentPosY = 0; // use this variable to detect if we are scrolling up or down
            this._itemPool = new cc.NodePool();
            for (let index = 0; index < this.spawnCount; ++index) {
                let item = cc.instantiate(this.itemTemplate);
                this._itemPool.put(item);
            }
            this.hasInit = false;
            this.hasInitEx = true;
        }
    },

    onDestroy: function() {
        this._itemPool.clear();

        for (let i = 0; i < this.items.length; i++) {
            let item = this.items[i];
            item.destroy();
        }

        this._super();
    },

    reset: function() {
        this.totalCount = 0;
        this.offsetIndex = 0;
        this.scrollView.scrollToTop();
    },

    resetItemPool: function() {
        this._init();
        if (this.items) {
            for (let i = 0; i < this.items.length; ++i) {
                this._itemPool.put(this.items[i]);
                this.items[i].getComponent("ItemView").reset();
            }
        }
        this.hasInit = false;
        this.items = [];
        this.content.removeAllChildren();
    },

    handleRefreshItemInfoList: function(latestItemList) {
        this.resetItemPool();
        this.init(latestItemList);
    },

    init: function(itemInfoList) {
        this._init();
        this.ItemInfoList = itemInfoList;
        this.totalCount = this.ItemInfoList.length;
        this.offsetIndex = this.offsetIndex < this.totalCount ? this.offsetIndex : 0;
        this.realSpawnCount = this.spawnCount < this.totalCount ? this.spawnCount : this.totalCount;
        this.content.height = this.totalCount * (this.itemTemplate.data._contentSize.height + this.spacing); //+ this.spacing; // get total content height

        this.initItemCount = this.realSpawnCount + this.offsetIndex;
        this.initItemCurrentIndex = this.offsetIndex;
        if (false === this.bSplitLoading) {
            for (let i = 0 + this.offsetIndex; i < this.realSpawnCount + this.offsetIndex; ++i) { // spawn items, we only need to do this once
                let item = this._itemPool.get();
                item.scale = this.itemScale;
                this.content.addChild(item);
                item.setPosition(0, -item.height * (0.5 + i) - this.spacing * (i + 0));
                let itemView = item.getComponent("ItemView");
                if (false == itemView.updateItem(i, this.ItemInfoList[i])) {
                    this._itemPool.put(item);
                    item.removeFromParent();
                    continue;
                }
                itemView.setHead();
                this.items.push(item);
            }
        }

        if (false === this.bSplitLoading) {
            this.hasInit = true;
        }
    },

    setItemData: function(index) {
        let item = this._itemPool.get();
        item.scale = this.itemScale;
        this.content.addChild(item);
        item.setPosition(0, -item.height * (0.5 + index) - this.spacing * (index + 0));
        let itemView = item.getComponent("ItemView");
        if (false == itemView.updateItem(index, this.ItemInfoList[index])) {
            this._itemPool.put(item);
            item.removeFromParent();
        } else {
            itemView.setHead();
            this.items.push(item);
        }
    },

    update: function(dt) {
        //分帧加载
        if (false === this.hasInit && true === this.bSplitLoading) {
            if (this.initItemCurrentIndex < this.initItemCount) {
                this.setItemData(this.initItemCurrentIndex);
                this.initItemCurrentIndex++;
            } 
            return;
        }

        this.updateTimer += dt;
        if (this.updateTimer < this.updateInterval) return; // we don't need to do the math every frame
        this.updateTimer = 0;
        let items = this.items || [];
        let buffer = this.bufferZone;
        let isDown = this.scrollView.content.y < this.lastContentPosY; // scrolling direction
        let offset = (this.itemTemplate.data._contentSize.height + this.spacing) * items.length;
        for (let i = 0; i < items.length; ++i) {
            let viewPos = this.getPositionInView(items[i]);
            if (isDown) {
                // if away from buffer zone and not reaching top of content
                if (viewPos.y < -buffer && items[i].y + offset < 0) {
                    items[i].setPositionY(items[i].y + offset);
                    this.offsetIndex = this.offsetIndex - 1;
                    let itemView = items[i].getComponent("ItemView");
                    let itemIndex = itemView.itemIndex - items.length; //update item id
                    itemView.updateItem(itemIndex, this.ItemInfoList[itemIndex]);
                }
            } else {
                // if away from buffer zone and not reaching bottom of content
                let yvalue = items[i].y;
                if (viewPos.y > buffer && items[i].y - offset > -this.content.height) {
                    items[i].setPositionY(items[i].y - offset);
                    this.offsetIndex = this.offsetIndex + 1;
                    let itemView = items[i].getComponent("ItemView");
                    let sss = itemView.itemIndex;
                    let itemIndex = itemView.itemIndex + items.length;
                    itemView.updateItem(itemIndex, this.ItemInfoList[itemIndex]);
                }
            }
        }
        // update lastContentPosY
        this.lastContentPosY = this.scrollView.content.y;
    },

    getPositionInView: function(item) { // get item position in scrollview's node space
        let worldPos = item.parent.convertToWorldSpaceAR(item.position);
        let viewPos = this.scrollView.node.convertToNodeSpaceAR(worldPos);
        return viewPos;
    },

    scrollEvent: function(sender, event) {
        switch (event) {
            case 0: //Scroll to Top
                cc.log(".......................................0");
                break;
            case 1: //Scroll to Bottom
                cc.log(".......................................1");
                break;
            case 2: //Scroll to Left
                cc.log(".......................................2");
                break;
            case 3: //Scroll to Right
                cc.log(".......................................3");
                break;
            case 4: //Scrolling
                break;
            case 5: //Bounce Top
                cc.log(".......................................5");
                break;
            case 6: //Bounce bottom
                cc.log(".......................................6");
                break;
            case 7: //Bounce left
                cc.log(".......................................7");
                break;
            case 8: //Bounce right
                cc.log(".......................................8");
                break;
            case 9: //Auto scroll ended
                cc.log(".......................................9");
                break;
        }
    },
});