const { ccclass, property } = cc._decorator;

@ccclass
export default class DragonBonesTouch extends cc.Component {
    armatureDisplay: dragonBones.ArmatureDisplay;
    @property(cc.Prefab)
    shape: cc.Prefab = null;
    @property
    armatureNodePath: string = 'Canvas/Layout/DBNode/DB_Background/DB';
    @property
    toggleNodePath: string = 'Canvas/New Layout/New Layout/YAxisLayout/New Toggle';
    @property
    yPosToggleNodePath: string = 'Canvas/New Layout/New Layout/YDistanceLayout/New Toggle';
    @property
    YPosFix: number = -245;
    fixYAxis = -1;

    armatureNode: cc.Node;
    canvasNode: cc.Node;
    allShapeList: Array<cc.Node>;
    start() {
        this.armatureNode = cc.find(this.armatureNodePath);
        if (!this.armatureNode) {
            console.error(`在路径 ${this.armatureNodePath} 没有找到节点`);
            return;
        }
        if (!this.shape) {
            console.error(`this shape is null`);
            return;
        }
        let toggleNode = cc.find(this.toggleNodePath);
        if (!toggleNode) {
            console.error(`在路径 ${this.toggleNodePath} 没有找到toggle节点`);
            return;
        }
        let yPosToggleNode = cc.find(this.yPosToggleNodePath);
        if (!yPosToggleNode) {
            console.error(`在路径 ${this.yPosToggleNodePath} 没有找到yPosToggleNode节点`);
            return;
        }
        this.allShapeList = new Array<cc.Node>();
        this.toggleEventBind(toggleNode);
        this.yPosToggleEventBind(yPosToggleNode);

        this.armatureDisplay = this.armatureNode.getComponent(dragonBones.ArmatureDisplay);
        this.armatureDisplay.addEventListener(cc.Node.EventType.TOUCH_START, () => {
            console.log(`click ${this.armatureDisplay.node.name}`);
        }, this)
        this.canvasNode = cc.find('Canvas');
        dragonBones.BoundingBoxData;
        this.armatureDisplay.dragonAtlasAsset;


        console.log('this.armatureDisplay', this.armatureDisplay);
        this.node.on(cc.Node.EventType.TOUCH_MOVE, (e: cc.Event.EventTouch) => {
            console.warn('this.node.on');
            this.drawShape(e);
        }, this);
        this.node.on(cc.Node.EventType.TOUCH_START, (e: cc.Event.EventTouch) => {
            console.warn('this.node.on');
            this.drawShape(e);
        }, this)
        this.armatureDisplay.addEventListener(cc.Node.EventType.TOUCH_MOVE, (e: cc.Event.EventTouch) => {
            console.warn('this.armatureDisplay.addEventListener');
            this.drawShape(e);
        }, this)
        this.autoDraw();
    }
    toggleEventBind(toggleNode: cc.Node) {
        var checkEventHandler = new cc.Component.EventHandler();
        checkEventHandler.target = this.node; //这个 node 节点是你的事件处理代码组件所属的节点
        checkEventHandler.component = /<(\w+)>/i.exec(this.name)[1];
        checkEventHandler.handler = "fix";
        checkEventHandler.customEventData = "test";

        toggleNode.getComponent(cc.Toggle).checkEvents.push(checkEventHandler);

        toggleNode.dispatchEvent(new cc.Event('toggle', true));
    }
    yPosToggleEventBind(toggleNode: cc.Node) {
        var checkEventHandler = new cc.Component.EventHandler();
        checkEventHandler.target = this.node; //这个 node 节点是你的事件处理代码组件所属的节点
        checkEventHandler.component = /<(\w+)>/i.exec(this.name)[1];
        checkEventHandler.handler = "fixYPos";
        checkEventHandler.customEventData = "test";

        toggleNode.getComponent(cc.Toggle).checkEvents.push(checkEventHandler);

        toggleNode.dispatchEvent(new cc.Event('toggle', true));
    }
    fix(toggle: cc.Toggle, msg: string) {
        this.fixYAxis = toggle.isChecked ? -1 : 1;
        this.removeAllShape();
        this.autoDraw();
    }
    fixYPos(toggle: cc.Toggle, msg: string) {
        let y = toggle.isChecked ? this.YPosFix : 0;
        cc.find('Canvas/Layout/DBNode/DB_Background/DB').y =y;
        this.removeAllShape();
        this.autoDraw();
    }
    async removeAllShape() {
        this.allShapeList.forEach(shape => {
            if (shape.isValid) {
                let promise = new Promise((resolve, reject) => {
                    this.canvasNode.once('child-removed', resolve, this);
                });
                shape.destroy();
            }
        });
    }
    async autoDraw() {
        console.time('shape load time');
        let tempShape = this.getShape(new cc.Vec2(0, 0), this.shapeRedColor);
        let startPos = this.canvasNode.convertToNodeSpaceAR(new cc.Vec2(0, 0));
        let endPos = this.canvasNode.convertToNodeSpaceAR(new cc.Vec2(cc.winSize.width, cc.winSize.height));
        for (let x = startPos.x; x < endPos.x; x += tempShape.width) {
            for (let y = startPos.y; y < endPos.y; y += tempShape.height) {
                let color = this.shapeColor;
                let canvasPos = new cc.Vec2(x, y);
                let localPos = this.node.convertToNodeSpaceAR(this.node.convertToWorldSpaceAR(canvasPos));
                if (this.armatureDisplay.armature().containsPoint(localPos.x, this.fixYAxis * localPos.y)) {
                    color = this.shapeRedColor;
                    console.warn(`localPos点 ${localPos.toString()} 在龙骨内`);
                }
                let shape = this.getShape(canvasPos, color);
                await this.addOneShape(shape);
            }
        }
        let shape = this.getShape(startPos, cc.Color.YELLOW);
        this.addOneShape(shape);

        shape = this.getShape(endPos, cc.Color.BLUE);
        this.addOneShape(shape);
        console.timeEnd('shape load time');
    }
    async addOneShape(shape: cc.Node) {
        let promise = new Promise((resolve, reject) => {
            this.canvasNode.once('child-added', resolve, this);
        });
        this.canvasNode.addChild(shape);
        await promise;
    }
    shapeColor: cc.Color = cc.Color.YELLOW;//green
    shapeRedColor = cc.Color.RED;
    shapeLineStyle = cc.Color.BLACK
    getShape(pos: cc.Vec2, color: cc.Color) {
        let shape = cc.instantiate(this.shape);
        shape.x = pos.x;
        shape.y = pos.y;
        shape.color = color;
        shape.opacity = 125;
        shape.active = true;
        this.allShapeList.push(shape);
        return shape;
    }
    isAdding = false;
    drawShape(e: cc.Event.EventTouch) {
        if (this.isAdding) {
            console.log(`添加子节点中……`);
            return;
        }
        let color = this.shapeColor;
        let localPos = this.node.convertToNodeSpaceAR(new cc.Vec2(e.getLocationX(), e.getLocationY()));
        // this.node.convertToNodeSpace(new cc.Vec2(e.getLocationX(), e.getLocationY()));
        if (this.armatureDisplay.armature().containsPoint(localPos.x, this.fixYAxis * localPos.y)) {
            color = this.shapeRedColor;
            console.warn(`触摸到了龙骨`);
        }
        let canvasPos = this.canvasNode.convertToNodeSpaceAR(new cc.Vec2(e.getLocationX(), e.getLocationY()));
        let shape = this.getShape(canvasPos, color);
        // console.time('start add');
        this.isAdding = true;
        this.canvasNode.on('child-added', () => {
            this.isAdding = false;
            // console.warn('child-added');
            // console.timeEnd('start add');
        }, this);
        this.canvasNode.addChild(shape);
        setTimeout(() => {
            // this.root.removeChild(shape);
        }, 2500);


    }
}
