cc.Class({
    extends: cc.Component,

    properties: {
        isKeyDown: false,
        camera: cc.Camera,
        direction: 0,
        block: cc.Sprite
    },


    onLoad() {
        cc.director.getPhysicsManager().enabled = true;
        cc.director.getPhysicsManager().debugDrawFlags = cc.PhysicsManager.DrawBits.e_aabbBit |
            cc.PhysicsManager.DrawBits.e_pairBit |
            cc.PhysicsManager.DrawBits.e_centerOfMassBit |
            cc.PhysicsManager.DrawBits.e_jointBit |
            cc.PhysicsManager.DrawBits.e_shapeBit
        ;
    },

    onKeyDown(event) {
        console.log('keydown');
        switch (event.keyCode) {
            case cc.macro.KEY.up:
                this.isKeyDown = true;
                this.direction = 1;
                break;
            case cc.macro.KEY.down:
                this.isKeyDown = true;
                this.direction = -1;
                break;
            case cc.macro.KEY.left:
                this.isKeyDown = true;
                this.direction = 2;
                break;
            case cc.macro.KEY.right:
                this.isKeyDown = true;
                this.direction = -2;
                break;
            default:
                this.isKeyDown = false;
                break;
        }
        this.moveCamera();
    },

    moveCamera() {
        if (this.isKeyDown) {
            let p;
            switch (this.direction) {
                case 1:
                    p = cc.v2(0, 100);
                    break;
                case -1:
                    p = cc.v2(0, -100);
                    break;
                case 2:
                    p = cc.v2(-100, 0);
                    break;
                case -2:
                    p = cc.v2(100, 0);
                    break;
            }
            this.camera.getComponent(cc.RigidBody).linearVelocity = p;
        } else {
            this.camera.getComponent(cc.RigidBody).linearVelocity = cc.v2(0, 0);
        }
    },

    onLoad() {
        cc.director.getPhysicsManager().enabled = true;
        cc.director.getPhysicsManager().debugDrawFlags = cc.PhysicsManager.DrawBits.e_aabbBit |
            cc.PhysicsManager.DrawBits.e_pairBit |
            cc.PhysicsManager.DrawBits.e_centerOfMassBit |
            cc.PhysicsManager.DrawBits.e_jointBit |
            cc.PhysicsManager.DrawBits.e_shapeBit
        ;
    },

    onKeyUp() {
        this.isKeyDown = false;
    },

    start() {
        cc.systemEvent.on(cc.SystemEvent.EventType.KEY_DOWN, this.onKeyDown, this);
        cc.systemEvent.on(cc.SystemEvent.EventType.KEY_UP, this.onKeyUp, this);
    },

    updateRigidBody() {
        let component = this.block.node.getComponent(cc.PhysicsBoxCollider);
        component.offset.y = -this.camera.node.y;
        component.apply();
    },

    update(dt) {
        // this.updateRigidBody();
        console.log('块的坐标: [%s,%s], 摄像机:[%s,%s]', this.block.node.x, this.block.node.y, this.camera.node.x, this.camera.node.y);
    },
});
