const { ccclass, property } = cc._decorator;

type Nullable<T> = null | T;

@ccclass
export default class TextureGenerator extends cc.Component {

    @property(cc.Node) public renderer: Nullable<cc.Node> = null;

    public renderSprite: Nullable<cc.Sprite> = null;
    public renderTexture: any;

    public onLoad(): void {
        this.renderSprite = this.renderer.getComponent(cc.Sprite);
        if (this.renderSprite === null) {
            console.info(`[TextureGenerator onLoad]: Missing componenet cc.Sprite on render node.`, this.renderer);
            this.enabled = false;
            return;
        }
    }

    public start(): void {
        this.renderTexture = (<any>cc).RenderTexture.create(this.node.width, this.node.height);
    }

    public update(): void {
        this.renderTexture.beginWithClear(0, 0, 0, 0, 0, 0);
        (<any>this.node)._sgNode.visit();
        this.renderTexture.end();
        const frame: cc.SpriteFrame = this.renderTexture.getSprite().getSpriteFrame();
        this.renderSprite.spriteFrame = frame;
    }
}
