"use strict";

const { join } = require("path");
const { exec } = require("child_process");
const { readFileSync } = require("fs");
const pkg = require("./package.json");

// 加载编辑器里的 Vue
module.paths.push(join(Editor.App.path, "node_modules"));
const Vue = require("vue/dist/vue.js");

let panel = null;
let vm = null;

// 面板内的 css
exports.style = readFileSync(join(__dirname, "./panel.css"));

// 面板 html
exports.template = readFileSync(join(__dirname, "./panel.html"));

// 节点选择器
exports.$ = {
  root: "#root",
};

// messages 对应的方法
exports.methods = {
  createAsset(assetInfo) {
    console.log("get asset", assetInfo);
  },
  createNode(nodeInfo) {
    console.log("get node", nodeInfo);
  },
};

// 面板显示完成后触发
exports.ready = function () {
  panel = this;

  vm = new Vue({
    el: panel.$.root,
    data: {},
    methods: {},
  });
};

// 面板关闭的时候会触发，如果 return false，会中断关闭流程
exports.beforeClose = function () {};

// 面板确定要关闭后，会触发这个函数，在这里需要保存面板需要存储的数据
exports.close = function () {};
