var ActionType = cc.Enum({
    NONE: 0,
    MOVE: 1,
    SCALE: 2,
    MOVEUPTODOWN: 3,
    MOVETOUP: 4,    // 往上滑动到半屏
    HALFSCREEN: 5,   // 下半屏，且不能滑动
    MOVEDOWNTOUP: 6,
    MOVELEFT: 7,
});

cc.Class({
    extends: cc.Component,

    editor: CC_EDITOR && {
        menu: 'YY/BasePanel',
        disallowMultiple: true,
    },

    properties: {
        PanelName: 'NoName',
        PanelSet: '',
        duration: 0.2,
        fullscreen: true,
        autoDestroy: true,
        doAction: {
            default: ActionType.MOVE,
            type: ActionType,
        },
        touckBlock: true,
        _isOpen: false,
        needBG: false,
        BgOpacity: 0x80,
        ManageKeyBoard: false,
    },

    Show: function (params) {
        this._isOpen = true;
        this.node.active = true;

        if (this.doAction === ActionType.MOVETOUP) {
            this.node.height = this._height - (this._height / 3);
        } else if (this.doAction === ActionType.HALFSCREEN) {
            this.node.height = this._height * 0.5;
        } else {
            this.node.height = this._height;
        }

        if (params) {
            if (!params.behindPageView) {
                this._startFadeIn(this);
            }
        } else {
            this._startFadeIn(this);
        }
        this.onOpen(params);

    },

    Destroy: function () {
        this.onClose();
        this.autoDestroy = true;
        this._startFadeOut(this);
    },

    Close: function (params) {
        if (!this._isOpen) {
            return;
        }
        this._isOpen = false;
        this.onClose(params);
        this.autoDestroy = false; //FIXME
        this._startFadeOut(this);
    },

    CloseDirect: function () {
        if (!this._isOpen) {
            return;
        }
        this._isOpen = false;
        this.onClose();
        this.autoDestroy = false; //FIXME
        this._container._onStartClose(this);
        this._onFadeOutFinish();
    },

    ShowMenu: function () {

    },

    //执行打开操作时触发
    onOpen: function (_unusedparams) {

    },

    //动画播完触发
    onShow: function () {
    },
    //关闭之前触发
    onClose: function () {
    },

    onResume: function () { },

    onPause: function () { },

    // 关闭动画完毕
    onCloseFinished: function () {
    },

    onBackKey: function () {
        this.Close();
    },

    _doFadeIn: function () {
        this.node.stopAllActions();
        var scale = 1;
        if (this.doAction === ActionType.MOVE) {
            this.node.position = cc.p(this._pos.x + 640 * scale, this._pos.y);
            this.node.runAction(this.actionFadeIn);
        } else if (this.doAction === ActionType.SCALE) {
            this.node.scale = 0.01;
            this.node.runAction(this.actionFadeIn);
        } else if (this.doAction === ActionType.MOVEUPTODOWN) {
            this.node.position = cc.p(this._pos.x, this._pos.y + 800 * scale);
            this.node.runAction(this.actionFadeIn);
        } else if (this.doAction === ActionType.MOVETOUP) {
            // 由于切换地图时，Container大小会变化，所以Action的位置应根据Container的大小重新计算
            const cbFadeOut = cc.callFunc(this._onFadeOutFinish, this);
            const cbFadeIn = cc.callFunc(this._onFadeInFinish, this);
            let height = this._height;
            this.actionFadeIn = cc.sequence(cc.moveTo(this.duration, cc.p(0, this._pos.y - height / 3)).easing(cc.easeInOut(2)), cbFadeIn);
            this.actionFadeOut = cc.sequence(cc.moveBy(this.duration, cc.p(0, -height)).easing(cc.easeInOut(2)), cbFadeOut);
            this.deltaMove = 0;

            var y = this._pos.y - height;
            this.node.position = cc.p(this._pos.x, y);
            this.node.runAction(this.actionFadeIn);
        } else if (this.doAction === ActionType.HALFSCREEN) {
            const cbFadeOut = cc.callFunc(this._onFadeOutFinish, this);
            const cbFadeIn = cc.callFunc(this._onFadeInFinish, this);
            let height = this._height;
            this.actionFadeIn = cc.sequence(cc.moveTo(this.duration, cc.p(0, 0)).easing(cc.easeInOut(2)), cbFadeIn);
            this.actionFadeOut = cc.sequence(cc.moveBy(this.duration, cc.p(0, -height)).easing(cc.easeInOut(2)), cbFadeOut);
            this.node.position = cc.p(this._pos.x, -height);
            this.node.runAction(this.actionFadeIn);
        } else if (this.doAction == ActionType.MOVEDOWNTOUP) {
            this.node.position = cc.p(this._pos.x, this._pos.y - 800 * scale);
            this.node.runAction(this.actionFadeIn);
        } else if (this.doAction === ActionType.MOVELEFT) {
            this.node.position = cc.p(this._pos.x - 640 * scale, this._pos.y);
            this.node.runAction(this.actionFadeIn);
        } else {
            setTimeout(this._onFadeInFinish.bind(this));
        }
    },

    _startFadeIn: function () {
        this._container._onStartShow(this);
        cc.eventManager.pauseTarget(this._container.node, true);
        this._doFadeIn();
    },

    _doFadeOut: function () {
        this.node.stopAllActions();
        if (this.doAction !== ActionType.NONE) {
            this.node.runAction(this.actionFadeOut);
        } else {
            this._onFadeOutFinish();
        }
    },

    _startFadeOut: function () {
        cc.eventManager.pauseTarget(this._container.node, true);
        this._container._onStartClose(this);
        this._doFadeOut();
    },

    _onFadeInFinish: function () {
        cc.eventManager.resumeTarget(this._container.node, true);
        if (this.doAction !== ActionType.MOVETOUP && this.doAction !== ActionType.HALFSCREEN) {
            this.node.setPosition(this._pos);
        }
        this.node.scale = 1;
        this._container._onShow(this);
    },

    _onFadeOutFinish: function () {
        cc.eventManager.resumeTarget(this._container.node, true);
        if (this.autoDestroy) {
            this._container._onDestroy(this);
        } else {
            this._container._onClose(this);
            setTimeout(this.onCloseFinished.bind(this));
        }
    },

    OpenPanel: function (name, params) {
        this._container.Open(name, params);
    },

    onLoad: function () {
        this.node.active = false;

        const cbFadeOut = cc.callFunc(this._onFadeOutFinish, this);
        const cbFadeIn = cc.callFunc(this._onFadeInFinish, this);

        var scale = 1;

        switch (this.doAction) {
            case (ActionType.NONE):
                this.actionFadeIn = null;
                this.actionFadeOut = null;
                break;
            case (ActionType.MOVE):
                this.actionFadeIn = cc.sequence(cc.moveBy(this.duration, cc.p(-640 * scale, 0)).easing(cc.easeInOut(2)), cbFadeIn);
                this.actionFadeOut = cc.sequence(cc.moveBy(this.duration, cc.p(640 * scale, 0)).easing(cc.easeInOut(2)), cbFadeOut);
                break;
            case (ActionType.SCALE):
                this.actionFadeIn = cc.sequence(cc.scaleTo(this.duration, 1).easing(cc.easeInOut(2)), cbFadeIn);
                this.actionFadeOut = cc.sequence(cc.scaleTo(this.duration, 0.01).easing(cc.easeInOut(2)), cbFadeOut);
                break;
            case (ActionType.MOVEUPTODOWN):
                this.actionFadeIn = cc.sequence(cc.moveBy(this.duration, cc.p(0, -800 * scale)).easing(cc.easeInOut(2)), cbFadeIn);
                this.actionFadeOut = cc.sequence(cc.moveBy(this.duration, cc.p(0, 800 * scale)).easing(cc.easeInOut(2)), cbFadeOut);
                break;
            case (ActionType.MOVEDOWNTOUP):
                this.actionFadeIn = cc.sequence(cc.moveBy(this.duration, cc.p(0, 800 * scale)).easing(cc.easeInOut(2)), cbFadeIn);
                this.actionFadeOut = cc.sequence(cc.moveBy(this.duration, cc.p(0, -800 * scale)).easing(cc.easeInOut(2)), cbFadeOut);
                break;
            case (ActionType.MOVETOUP):
                break;
            case (ActionType.HALFSCREEN):
                break;
            case (ActionType.MOVELEFT):
                this.actionFadeIn = cc.sequence(cc.moveBy(this.duration, cc.p(640 * scale, 0)).easing(cc.easeInOut(2)), cbFadeIn);
                this.actionFadeOut = cc.sequence(cc.moveBy(this.duration, cc.p(-640 * scale, 0)).easing(cc.easeInOut(2)), cbFadeOut);
                break;
            default:
        }

        if (this.ManageKeyBoard) {
            this._EditBox = this.getComponentsInChildren('cc.EditBox');
        }
    },

    onEnable: function () {
        if (this.ManageKeyBoard) {
            this.node.on(cc.Node.EventType.TOUCH_START, this._onPanelTouchCapture, this, true);
        }

        if (this.touckBlock) {
            this.node.on(cc.Node.EventType.TOUCH_START, this._onPanelTouch, this);
            this.node.on(cc.Node.EventType.TOUCH_MOVE, this._onPanelTouch, this);
            this.node.on(cc.Node.EventType.TOUCH_END, this._onPanelTouch, this);
            this.node.on(cc.Node.EventType.TOUCH_CANCEL, this._onPanelTouch, this);
        }
    },

    onDisable: function () {
        if (this.ManageKeyBoard) {
            this.node.off(cc.Node.EventType.TOUCH_START, this._onPanelTouchCapture, this, true);
        }

        this.node.off(cc.Node.EventType.TOUCH_START, this._onPanelTouch, this);
        this.node.off(cc.Node.EventType.TOUCH_MOVE, this._onPanelTouch, this);
        this.node.off(cc.Node.EventType.TOUCH_END, this._onPanelTouch, this);
        this.node.off(cc.Node.EventType.TOUCH_CANCEL, this._onPanelTouch, this);
    },

    _onPanelTouchCapture: function () {
        this.closeKeyBoard();
    },

    closeKeyBoard: function() {
        if (this._EditBox) {
            for (var i = 0; i< this._EditBox.length; i++) {
                this._EditBox[i].closeKeyboard();
            }
        }
    },

    _onPanelTouch: function (event) {
        event.stopPropagation();
    },

    findComponent: function (startNode, endNode, component) {
        if (startNode === endNode) return null;
        var comp = startNode.getComponent(component);
        if (comp) {
            return comp;
        } else {
            return this.findComponent(startNode.parent, endNode, component);
        }
    },

    _cancelButtonClick: function (event) {
        var deltaMove = event.getDelta();
        var needCancelTouch = false;
        if (cc.sys.isMobile) {
            if (cc.pLength(deltaMove) > 7) {
                needCancelTouch = true;
            }
        } else {
            needCancelTouch = true;
        }

        return needCancelTouch;
    },

    onCloseSlidingPanel: function () {

    },

    ClosePanelSets: function () {
        if (this.PanelSet !== '') {
            CommonUtil.ClosePanelSets(this.PanelSet);
        }
    }

});
