var BasePanel = require('BasePanel');

var PanelManager = {
    _activeView: null,
    _viewContainers: {},
    _panels: {},
    _loadingPanels: {},
    _LastPanel: null,

    _busyPanel: null,
    _showBusy: false,

    node: null,

    _lastBackTime: 0,

    setAccelerEnabled: function (flag) {
        if (CC_JSB) {
            cc.Device.setAccelerometerEnabled(flag);
        }
    },

    Init: function () {
        var self = this;
        if (CC_JSB) {
            cc.Device.setAccelerometerInterval(1 / 10);
        }
        this.node = cc.Canvas.instance.node;

        var node = new cc.Node();
        var parentNode = this.node;
        node.color = cc.Color.BLACK;
        node.opacity = 128;
        node.parent = parentNode;
        node.setContentSize(parentNode.getContentSize());
        node.height = cc.director.getWinSizeInPixels().height;
        this._BGNode = node;

        cc.eventManager.addListener({
            event: cc.EventListener.KEYBOARD,
            onKeyPressed: function (keyCode) {
                var lastPanel = self._LastPanel;
                if (!lastPanel) {
                    return;
                }
                if ((keyCode === cc.KEY.back || keyCode === cc.KEY.escape) && !self._showBusy) {
                    lastPanel.onBackKey();
                } else if (keyCode === cc.KEY.menu) {
                    lastPanel.ShowMenu();
                }
            }
        }, parentNode);

        cc.eventManager.addListener({
            event: cc.EventListener.ACCELERATION,
            callback: function (acc) {
                cc.director.GlobalEvent.emitEvent('DEVICE_ACCELERATION', acc);
            }
        }, parentNode);

    },


    // FIXME 这是个临时方案，最终要有窗口分组堆栈一类的机制来处理
    CloseAllPanelToLast: function () {
        while (this._LastPanel && this._LastPanel._PrevPanel) {
            this._LastPanel.CloseDirect();
        }
    },

    Open: function (name, params) {
        var self = this;
        var panels = this._panels;
        var panel = panels[name];

        if (panel && panel.isValid) {

            if (panel._isOpen) {
                if (panel._NextPanel) {
                    panel._NextPanel._PrevPanel = panel._PrevPanel;
                }
                if (panel._PrevPanel) {
                    panel._PrevPanel._NextPanel = panel._NextPanel;
                }
            }

            if (panel === this._LastPanel) {
                var pervPanel = panel._PrevPanel;
                if (pervPanel && !panel.fullscreen) {
                    pervPanel.node.active = true;
                }
            }
            panel.Show(params);

            return;
        }

        if (this._loadingPanels[name]) {
            return;
        }
        this._loadingPanels[name] = true;
        
        console.time('load panel:' + name);
        cc.loader.loadRes('Prefabs/' + name, cc.Prefab, function (err, prefab) {
            console.timeEnd('load panel:' + name);
            
            self._loadingPanels[name] = false;

            if (err) {
                cc.error(err.message || err);
                return;
            }

            console.time('instantiate panel:' + name);
            var node = cc.instantiate(prefab);
            console.timeEnd('instantiate panel:' + name);
            var parentNode = cc.Canvas.instance.node;
            node.setContentSize(parentNode.getContentSize());
            panel = node.getComponent(BasePanel);
            if (panel === null) {
                cc.error('basepanel not found');
                return;
            }
            parentNode.addChild(node);
            panels[name] = panel;

            var x = (node._anchorPoint.x - 0.5) * node.width + (0.5 - parentNode._anchorPoint.x) * parentNode.width;
            var y = (node._anchorPoint.y - 0.5) * node.height + (0.5 - parentNode._anchorPoint.y) * parentNode.height;
            panel._height = panel.node.height;
            panel._pos = cc.p(x, y);
            node.setPosition(panel._pos);
            panel.name = name;
            panel._container = self;
            console.time('Show panel:' + name);
            panel.Show(params);
            console.timeEnd('Show panel:' + name);
        });
    },

    Close: function (name) {
        var panel = this._panels[name];
        if (panel && panel.isValid) {
            panel.Close();
        }
    },

    CloseDirect: function (name) {
        var panel = this._panels[name];
        if (panel && panel.isValid) {
            panel.CloseDirect();
        }
    },

    _onStartClose: function (panel) {
        var prevPanel = panel._PrevPanel;
        if (prevPanel) {
            prevPanel.node.active = true;
            if (prevPanel.needBG) {
                this._BGNode.setSiblingIndex(999);
                this._BGNode.active = true;
            } else {
                this._BGNode.active = false;
            }
            prevPanel.node.setSiblingIndex(1000);
            prevPanel.onResume();

            panel.node.setSiblingIndex(1001);

            if (!prevPanel.fullscreen) {
                prevPanel = prevPanel._PrevPanel;
                while (prevPanel) {
                    prevPanel.node.active = true;
                    if (prevPanel.fullscreen) {
                        break;
                    }
                    prevPanel = prevPanel._PrevPanel;
                }
            }
        }

        if (this._LastPanel === panel) {
            this._LastPanel = panel._PrevPanel;
            if (this._LastPanel) {
                this._LastPanel._NextPanel = null;
            }
        } else {
            if (panel._PrevPanel) {
                panel._PrevPanel._NextPanel = panel._NextPanel;
            }
            if (panel._NextPanel) {
                panel._NextPanel._PrevPanel = panel._PrevPanel;
            }
        }
        panel._PrevPanel = null;
        panel._NextPanel = null;
    },

    _onStartShow: function (panel) {
        if (panel.needBG) {
            this._BGNode.setSiblingIndex(999);
            this._BGNode.opacity = panel.BgOpacity;
            this._BGNode.active = true;
        } else {
            this._BGNode.active = false;
        }
        panel.node.setSiblingIndex(1000);

        var lastPanel = this._LastPanel;
        if (panel !== lastPanel) {
            panel._PrevPanel = lastPanel;
            panel._NextPanel = null;
            if (lastPanel) {
                lastPanel._NextPanel = panel;
                lastPanel.closeKeyBoard();
                lastPanel.onPause();
            }
            this._LastPanel = panel;
        }
    },

    _onShow: function (panel) {
        if (panel.fullscreen) {
            var prev = panel._PrevPanel;
            while (prev) {
                prev.node.active = false;
                prev = prev._PrevPanel;
            }
        }
        panel.onShow();
    },

    _onClose: function (panel) {
        panel.closeKeyBoard();
        panel.node.active = false;
        panel.node.setSiblingIndex(0);
    },

    _onDestroy: function (panel) {
        panel.node.destroy();
        this._panels[panel.name] = null;
    },

    getPanel: function (name) {
        return this._panels[name];
    },


};

module.exports = PanelManager;