"use strict";
cc._RF.push(module, 'e5050RT/1FHC5etNi40ztP+', 'HotUpdate');
// Script/HotUpdate.js

'use strict';

var BasePanel = require('BasePanel');

cc.Class({
    extends: cc.Component,

    properties: {
        panel: BasePanel,
        manifestUrl: cc.RawAsset,
        _updating: false,
        _canRetry: false,
        _storagePath: ''
    },

    checkCb: function checkCb(event) {
        this.panel.onUpdateCallback(event, false);
        switch (event.getEventCode()) {
            case jsb.EventAssetsManager.ERROR_NO_LOCAL_MANIFEST:
                cc.log('---->>> checkCb: 跳过更新');
                break;
            case jsb.EventAssetsManager.ERROR_DOWNLOAD_MANIFEST:
            case jsb.EventAssetsManager.ERROR_PARSE_MANIFEST:
                cc.log('---->>> checkCb: 读取版本信息失败');
                break;
            case jsb.EventAssetsManager.ALREADY_UP_TO_DATE:
                cc.log('---->>> checkCb: 已经是最新版本');
                break;
            case jsb.EventAssetsManager.NEW_VERSION_FOUND:
                cc.log('---->>> checkCb: 发现新版本，开始更新');
                //this.panel.fileProgress.setValue(0);
                //this.panel.byteProgress.setValue(0);
                //this._updating = false;
                break;
            default:
                return;
        }

        cc.eventManager.removeListener(this._checkListener);
        this._checkListener = null;
        this._updating = false;
    },

    updateCb: function updateCb(event) {
        this.panel.onUpdateCallback(event, true);
        //var needRestart = false;
        var failed = false;
        switch (event.getEventCode()) {
            case jsb.EventAssetsManager.ERROR_NO_LOCAL_MANIFEST:
                failed = true;
                cc.log('---->>> updateCb: ERROR_NO_LOCAL_MANIFEST');
                break;
            case jsb.EventAssetsManager.UPDATE_PROGRESSION:
                //this.panel.byteProgress.setValue(event.getPercent());
                //this.panel.fileProgress.setValue(event.getPercentByFile());

                //this.panel.fileLabel.string = event.getDownloadedFiles() + ' / ' + event.getTotalFiles();
                //this.panel.byteLabel.string = event.getDownloadedBytes() + ' / ' + event.getTotalBytes();

                //var msg = event.getMessage();
                //if (msg) {
                //    this.panel.info.string = '更新文件: ' + msg;
                // cc.log(event.getPercent()/100 + '% : ' + msg);
                //}
                //cc.log('--------------------------------->>> updateCb: UPDATE_PROGRESSION');

                break;
            case jsb.EventAssetsManager.ERROR_DOWNLOAD_MANIFEST:
            case jsb.EventAssetsManager.ERROR_PARSE_MANIFEST:
                failed = true;
                cc.log('---->>> updateCb: ERROR_DOWNLOAD_MANIFEST');
                break;
            case jsb.EventAssetsManager.ALREADY_UP_TO_DATE:
                failed = true;
                cc.log('---->>> updateCb: ALREADY_UP_TO_DATE');
                break;
            case jsb.EventAssetsManager.UPDATE_FINISHED:
                //needRestart = true;
                cc.log('---->>> updateCb: UPDATE_FINISHED');
                break;
            case jsb.EventAssetsManager.UPDATE_FAILED:
                this._updating = false;
                this._canRetry = true;
                cc.log('---->>> updateCb: UPDATE_FAILED');
                break;
            case jsb.EventAssetsManager.ERROR_UPDATING:
                cc.log('---->>> updateCb: ERROR_UPDATING');
                break;
            case jsb.EventAssetsManager.ERROR_DECOMPRESS:
                //this.panel.info.string = event.getMessage();
                cc.log('---->>> updateCb: ERROR_UPDATING');
                break;
            default:
                break;
        }

        if (failed) {
            cc.eventManager.removeListener(this._updateListener);
            this._updateListener = null;
            this._updating = false;
            //this.panel.Close();
        }

        // if (needRestart) {
        //     cc.eventManager.removeListener(this._updateListener);
        //     this._updateListener = null;
        //     // Prepend the manifest's search path
        //     var searchPaths = jsb.fileUtils.getSearchPaths();
        //     var newPaths = this._am.getLocalManifest().getSearchPaths();
        //     Array.prototype.unshift(searchPaths, newPaths);
        //     // This value will be retrieved and appended to the default search path during game startup,
        //     // please refer to samples/js-tests/main.js for detailed usage.
        //     // !!! Re-add the search paths in main.js is very important, otherwise, new scripts won't take effect.
        //     cc.sys.localStorage.setItem('HotUpdateSearchPaths', JSON.stringify(searchPaths));
        //     jsb.fileUtils.setSearchPaths(searchPaths);

        //     cc.audioEngine.stopAll();
        //     cc.game.restart();
        // }
    },

    retry: function retry() {
        if (!this._updating && this._canRetry) {
            this._canRetry = false;

            //this.panel.info.string = 'Retry failed Assets...';
            this._am.downloadFailedAssets();
        }
    },

    checkUpdate: function checkUpdate() {
        if (this._updating) {
            this.panel.checkUpdate.string = '检查更新 ...';
            return;
        }
        if (this._am.getState() === jsb.AssetsManager.State.UNINITED) {
            this._am.loadLocalManifest(this.manifestUrl);
        }
        if (!this._am.getLocalManifest() || !this._am.getLocalManifest().isLoaded()) {
            this.panel.checkUpdate.string = '本地版本验证失败 ...';
            return;
        }
        this._checkListener = new jsb.EventListenerAssetsManager(this._am, this.checkCb.bind(this));
        cc.eventManager.addListener(this._checkListener, 1);

        this._am.checkUpdate();
        this._updating = true;
    },

    hotUpdate: function hotUpdate() {
        if (this._am && !this._updating) {
            this._updateListener = new jsb.EventListenerAssetsManager(this._am, this.updateCb.bind(this));
            cc.eventManager.addListener(this._updateListener, 1);

            if (this._am.getState() === jsb.AssetsManager.State.UNINITED) {
                this._am.loadLocalManifest(this.manifestUrl);
            }

            this._failCount = 0;
            this._am.update();
            this._updating = true;
        }
    },

    // Setup your own version compare handler, versionA and B is versions in string
    // if the return value greater than 0, versionA is greater than B,
    // if the return value equals 0, versionA equals to B,
    // if the return value smaller than 0, versionA is smaller than B.
    versionCompareHandle: function versionCompareHandle(versionA, versionB) {
        cc.log('JS Custom Version Compare: version A is ' + versionA + ', version B is ' + versionB);
        var vA = versionA.split('.');
        var vB = versionB.split('.');
        for (var i = 0; i < vA.length; ++i) {
            var a = parseInt(vA[i]);
            var b = parseInt(vB[i] || 0);
            if (a === b) {
                continue;
            } else {
                return a - b;
            }
        }
        if (vB.length > vA.length) {
            return -1;
        } else {
            return 0;
        }
    },

    // use this for initialization
    onLoad: function onLoad() {
        // Hot update is only available in Native build
        if (!CC_JSB) {
            return;
        }
        this._storagePath = (jsb.fileUtils ? jsb.fileUtils.getWritablePath() : '/') + 'zizai-remote-asset';
        cc.log('Storage path for remote asset : ' + this._storagePath);

        // Setup your own version compare handler, versionA and B is versions in string
        // if the return value greater than 0, versionA is greater than B,
        // if the return value equals 0, versionA equals to B,
        // if the return value smaller than 0, versionA is smaller than B.
        // var versionCompareHandle = function (versionA, versionB) {
        //     cc.log('JS Custom Version Compare: version A is ' + versionA + ', version B is ' + versionB);
        //     var vA = versionA.split('.');
        //     var vB = versionB.split('.');
        //     for (var i = 0; i < vA.length; ++i) {
        //         var a = parseInt(vA[i]);
        //         var b = parseInt(vB[i] || 0);
        //         if (a === b) {
        //             continue;
        //         }
        //         else {
        //             return a - b;
        //         }
        //     }
        //     if (vB.length > vA.length) {
        //         return -1;
        //     }
        //     else {
        //         return 0;
        //     }
        // };

        // Init with empty manifest url for testing custom manifest
        this._am = new jsb.AssetsManager('', this._storagePath, this.versionCompareHandle);
        if (!cc.sys.ENABLE_GC_FOR_NATIVE_OBJECTS) {
            this._am.retain();
        }

        //var panel = this.panel;
        // Setup the verification callback, but we don't have md5 check function yet, so only print some message
        // Return true if the verification passed, otherwise return false
        this._am.setVerifyCallback(function (path, asset) {
            // When asset is compressed, we don't need to check its md5, because zip file have been deleted.
            var compressed = asset.compressed;
            // Retrieve the correct md5 value.
            var expectedMD5 = asset.md5;
            // asset.path is relative path and path is absolute.
            var relativePath = asset.path;
            // The size of asset file, but this value could be absent.
            //var size = asset.size;
            if (compressed) {
                //panel.info.string = 'Verification passed : ' + relativePath;
                //cc.log('Verification passed : ' + relativePath);
                return true;
            } else {
                //panel.info.string = 'Verification passed : ' + relativePath + ' (' + expectedMD5 + ')';
                //cc.log('Verification passed : ' + relativePath + ' (' + expectedMD5 + ')');
                return true;
            }
        });

        //this.panel.info.string = '';

        if (cc.sys.os === cc.sys.OS_ANDROID) {
            // Some Android device may slow down the download process when concurrent tasks is too much.
            // The value may not be accurate, please do more test and find what's most suitable for your game.
            this._am.setMaxConcurrentTask(2);
        }

        //this.panel.fileProgress.setValue(0);
        //this.panel.byteProgress.setValue(0);
    },

    onDestroy: function onDestroy() {
        if (this._updateListener) {
            cc.eventManager.removeListener(this._updateListener);
            this._updateListener = null;
        }
        if (this._am && !cc.sys.ENABLE_GC_FOR_NATIVE_OBJECTS) {
            this._am.release();
        }
    },

    restartGame: function restartGame() {
        cc.eventManager.removeListener(this._updateListener);
        this._updateListener = null;
        // Prepend the manifest's search path
        var searchPaths = jsb.fileUtils.getSearchPaths();
        var newPaths = this._am.getLocalManifest().getSearchPaths();
        Array.prototype.unshift(searchPaths, newPaths);
        // This value will be retrieved and appended to the default search path during game startup,
        // please refer to samples/js-tests/main.js for detailed usage.
        // !!! Re-add the search paths in main.js is very important, otherwise, new scripts won't take effect.
        cc.sys.localStorage.setItem('HotUpdateSearchPaths', JSON.stringify(searchPaths));
        jsb.fileUtils.setSearchPaths(searchPaths);

        cc.audioEngine.stopAll();
        cc.game.restart();
    }

});

cc._RF.pop();