cc.Class({
    extends: cc.Component,
    properties: {
        designMode:false,
        _images: {
            get() {

            }
        },
        serenceIdx: 0,
        serenceScript: [cc.Component],
        serences: [cc.Node],
        _ready:true,
    },

    // LIFE-CYCLE CALLBACKS:

    // onLoad () {},
    tryLoad() {
        function checkReady() {
            var readyCount = 0;
            var timeOver = false;
            for (let idx = 0; idx < img.length; idx++) {
                let imgReady = img[idx];
                this._ready = true
                if (imgReady) {
                    readyCount++
                } else {
                    this._ready = false;
                }
            }
            if (this._ready && !timeOver) {
                window.$ccTmp._imgTexture = img;
                console.log('资源加载完毕========')
            } else {
                var progress = readyCount / img.length * 100;
                progress = Math.round(progress);
                if (progress >= 95) {
                    setTimeout(() => {
                        if (!this._ready) {
                            timeOver = true;
                            this.tryLoad();
                        }
                    }, 5000);
                }
           
            }
        }
        for (let idx = 0; idx < window.$ccTmp._images.length; idx++) {
            let url = window.$ccTmp._images[idx];
            ((url, idx) => {
                cc.loader.load(url, (err, texture) => {
                    if (!err) {
                        img[idx] = texture
                        checkReady()
                    }
                });
            })(url, idx)
        }
    },
    start() {
        var _this = this;
        this.initRes()
        var img = new Array(window.$ccTmp._images.length)
        var checkReady = () => {
            var readyCount = 0;
            var timeOver = false;
            this._ready = true;
            for (let idx = 0; idx < img.length; idx++) {
                let imgReady = img[idx];
                if (imgReady) {
                    readyCount++
                } else {
                    this._ready = false;
                }
            }
            if (this._ready && !timeOver) {
                window.$ccTmp._imgTexture = img;
                setTimeout(() => {
                    if (window.$ccTmp && typeof window.$ccTmp.hideMubanLading == "function") {
                        window.$ccTmp.hideMubanLading();
                    }
                    _this.serenceStart();
                }, 500);
                return
            } else {
                var progress = readyCount / img.length * 100;
                progress = Math.round(progress);
                if (progress >= 95) {
                    setTimeout(() => {
                        if (!this._ready) {
                            timeOver = true;
                            console.log('资源加载超时=================')
                            if (window.$ccTmp && typeof window.$ccTmp.hideMubanLading == "function") {
                                window.$ccTmp.hideMubanLading();
                            }
                            _this.serenceStart();
                        }
                    }, 15000);//15000
                }
                if (progress >= 100) progress = 99;
                if (window.$ccTmp && typeof window.$ccTmp.setMubanProgress == "function") {
                    window.$ccTmp.setMubanProgress(progress);
                }
            }
        }
        for (let idx = 0; idx < window.$ccTmp._images.length; idx++) {
            let url = window.$ccTmp._images[idx];
            ((url, idx) => {
                cc.loader.load(url, (err, texture) => {
                    if (!err) {
                        img[idx] = texture
                        checkReady()
                    }
                });
            })(url, idx)
        }
    },
    initRes() {
        window.$ccTmp = window.$ccTmp || {}
        var img = {
            "1": "https://mlimg.qingzhanshi.com/mmbiz/4wB3jaTicUJISib7RgjMbtJgVUUXqHJ2ClXIBScH7iaRDibTXTicicnWiciaqoEVabic2v8F3o6gybUYiaT7NVqiaNqXiaJvJQ/640",
        };
        var imgArr = [];
        if (window && window.picsArray && typeof picsArray == "string") img = JSON.parse(window.picsArray);
        for (let key in img) {
            if (img.hasOwnProperty(key)) {
                let item = img[key];
                imgArr.push(item);
            }
        }
        window.$ccTmp._images = imgArr;
        window.$ccTmp._imageIdx = 0;
        window.$ccTmp.getImgUrl = function () {
            var idx = window.$ccTmp._imageIdx;
            var imgs = window.$ccTmp._images;
            var img = imgs[idx];
            idx++;
            window.$ccTmp._imageIdx = idx % imgs.length
            return img
        }
        window.$ccTmp.getImgData = function () {
            var idx = window.$ccTmp._imageIdx;
            var imgs = window.$ccTmp._images;
            var img = imgs[idx];
            var data = {
                img,
            }
            if (window.$ccTmp._imgTexture) {
                data.texture = window.$ccTmp._imgTexture[idx]
            }
            idx++;
            window.$ccTmp._imageIdx = idx % imgs.length
            return data
        }
       
        window.$ccTmp.nextSerence = () => {
            this.loadSerence()
        }
    },
    serenceStart() {
        this.loadSerence()
    },
    loadSerence() {
        // console.log(this.designMode)
        // if(this.designMode) return
        for (let idx = 0; idx < this.serences.length; idx++) {
            if (idx != this.serenceIdx) {
                this.serences[idx].active = false;
            } else {
                this.serences[idx].active = true;
            }

        }
        this.serenceScript[this.serenceIdx].setSerence()
        this.serenceIdx = (this.serenceIdx + 1) % this.serences.length
    }
});
