"use strict";
cc._RF.push(module, 'ca219fM0aVOvaQzp/jgbup1', 'main');
// script/main.js

'use strict';

cc.Class({
    extends: cc.Component,
    properties: {
        designMode: false,
        _images: {
            get: function get() {}
        },
        serenceIdx: 0,
        serenceScript: [cc.Component],
        serences: [cc.Node],
        _ready: true
    },

    // LIFE-CYCLE CALLBACKS:

    // onLoad () {},
    tryLoad: function tryLoad() {
        function checkReady() {
            var _this2 = this;

            var readyCount = 0;
            var timeOver = false;
            for (var idx = 0; idx < img.length; idx++) {
                var imgReady = img[idx];
                this._ready = true;
                if (imgReady) {
                    readyCount++;
                } else {
                    this._ready = false;
                }
            }
            if (this._ready && !timeOver) {
                window.$ccTmp._imgTexture = img;
                console.log('资源加载完毕========');
            } else {
                var progress = readyCount / img.length * 100;
                progress = Math.round(progress);
                if (progress >= 95) {
                    setTimeout(function () {
                        if (!_this2._ready) {
                            timeOver = true;
                            _this2.tryLoad();
                        }
                    }, 5000);
                }
            }
        }
        for (var idx = 0; idx < window.$ccTmp._images.length; idx++) {
            var url = window.$ccTmp._images[idx];
            (function (url, idx) {
                cc.loader.load(url, function (err, texture) {
                    if (!err) {
                        img[idx] = texture;
                        checkReady();
                    }
                });
            })(url, idx);
        }
    },
    start: function start() {
        var _this3 = this;

        var _this = this;
        this.initRes();
        var img = new Array(window.$ccTmp._images.length);
        var checkReady = function checkReady() {
            var readyCount = 0;
            var timeOver = false;
            _this3._ready = true;
            for (var idx = 0; idx < img.length; idx++) {
                var imgReady = img[idx];
                if (imgReady) {
                    readyCount++;
                } else {
                    _this3._ready = false;
                }
            }
            if (_this3._ready && !timeOver) {
                window.$ccTmp._imgTexture = img;
                setTimeout(function () {
                    if (window.$ccTmp && typeof window.$ccTmp.hideMubanLading == "function") {
                        window.$ccTmp.hideMubanLading();
                    }
                    _this.serenceStart();
                }, 500);
                return;
            } else {
                var progress = readyCount / img.length * 100;
                progress = Math.round(progress);
                if (progress >= 95) {
                    setTimeout(function () {
                        if (!_this3._ready) {
                            timeOver = true;
                            console.log('资源加载超时=================');
                            if (window.$ccTmp && typeof window.$ccTmp.hideMubanLading == "function") {
                                window.$ccTmp.hideMubanLading();
                            }
                            _this.serenceStart();
                        }
                    }, 15000); //15000
                }
                if (progress >= 100) progress = 99;
                if (window.$ccTmp && typeof window.$ccTmp.setMubanProgress == "function") {
                    window.$ccTmp.setMubanProgress(progress);
                }
            }
        };
        for (var idx = 0; idx < window.$ccTmp._images.length; idx++) {
            var url = window.$ccTmp._images[idx];
            (function (url, idx) {
                cc.loader.load(url, function (err, texture) {
                    if (!err) {
                        img[idx] = texture;
                        checkReady();
                    }
                });
            })(url, idx);
        }
    },
    initRes: function initRes() {
        var _this4 = this;

        window.$ccTmp = window.$ccTmp || {};
        var img = {
            "1": "https://mlimg.qingzhanshi.com/mmbiz/4wB3jaTicUJISib7RgjMbtJgVUUXqHJ2ClXIBScH7iaRDibTXTicicnWiciaqoEVabic2v8F3o6gybUYiaT7NVqiaNqXiaJvJQ/640"
        };
        var imgArr = [];
        if (window && window.picsArray && typeof picsArray == "string") img = JSON.parse(window.picsArray);
        for (var key in img) {
            if (img.hasOwnProperty(key)) {
                var item = img[key];
                imgArr.push(item);
            }
        }
        window.$ccTmp._images = imgArr;
        window.$ccTmp._imageIdx = 0;
        window.$ccTmp.getImgUrl = function () {
            var idx = window.$ccTmp._imageIdx;
            var imgs = window.$ccTmp._images;
            var img = imgs[idx];
            idx++;
            window.$ccTmp._imageIdx = idx % imgs.length;
            return img;
        };
        window.$ccTmp.getImgData = function () {
            var idx = window.$ccTmp._imageIdx;
            var imgs = window.$ccTmp._images;
            var img = imgs[idx];
            var data = {
                img: img
            };
            if (window.$ccTmp._imgTexture) {
                data.texture = window.$ccTmp._imgTexture[idx];
            }
            idx++;
            window.$ccTmp._imageIdx = idx % imgs.length;
            return data;
        };

        window.$ccTmp.nextSerence = function () {
            _this4.loadSerence();
        };
    },
    serenceStart: function serenceStart() {
        this.loadSerence();
    },
    loadSerence: function loadSerence() {
        // console.log(this.designMode)
        // if(this.designMode) return
        for (var idx = 0; idx < this.serences.length; idx++) {
            if (idx != this.serenceIdx) {
                this.serences[idx].active = false;
            } else {
                this.serences[idx].active = true;
            }
        }
        this.serenceScript[this.serenceIdx].setSerence();
        this.serenceIdx = (this.serenceIdx + 1) % this.serences.length;
    }
});

cc._RF.pop();