
const { ccclass, property } = cc._decorator;

@ccclass
export default class FitScene extends cc.Component {
    @property([cc.Widget])
    private widgetsTop: cc.Widget[] = []

    onLoad() {
        const canvas = this.getComponent(cc.Canvas)
        canvas.fitWidth = true
        canvas.fitHeight = false

        if (cc.winSize.height / cc.winSize.width < canvas.designResolution.height / canvas.designResolution.width) {
            canvas.fitWidth = false
            canvas.fitHeight = true
        }

        if (cc.sys.os === cc.sys.OS_IOS) {
            const safeArea = cc.sys.getSafeAreaRect()
            this.widgetsTop.forEach(w => {
                w.top += cc.winSize.height - safeArea.height
            });
        }
    }
}
