import SceneComp from "./Base/SceneComp";
// import Global from "./Global";

const { ccclass, property } = cc._decorator;

@ccclass
export default class Test3d extends cc.Component {
    @property(cc.Node)
    private coin: cc.Node = null

    @property([cc.Node])
    private pushs: cc.Node[] = []

    private _poolCoin = new cc.NodePool()
    private _coins = new Set<cc.Node>()

    genCoin() {
        for (let i = 0; i < 1; i++) {
            this.createCoin()
        }
    }

    createCoin() {
        let node
        if (this._poolCoin.size() > 0) {
            node = this._poolCoin.get()
        }
        else {
            node = cc.instantiate(this.coin)
        }
        this._coins.add(node)

        node.x = Math.random() * 6 - 3
        node.y = Math.random() * 2 + 2
        node.z = Math.random() * 6 - 3
        node.active = true
        node.parent = this.coin.parent
    }

    onLoad() {
        // super.onLoad()

        const mgr = cc.director.getPhysics3DManager()
        mgr.enabled = true
        mgr.useFixedTime = true
        mgr.deltaTime = 1 / 60

        this.pushs.forEach(push => {
            cc.tween(push)
                .to(2, { z: 0 })
                .to(2, { z: -3 })
                .union()
                .repeatForever()
                .start()
        })

        this.schedule(() => {
            this._coins.forEach(coin => {
                if (coin.y <= -15) {
                    this._poolCoin.put(coin)
                    this._coins.delete(coin)
                }
            })

            cc.log(this._poolCoin.size(), this._coins.size)
        }, 1)
    }

    onDestroy() {
        // super.onDestroy()

        const mgr = cc.director.getPhysics3DManager()
        mgr.enabled = false
    }

    onBack() {
        // Global.layerMgr.hallScene()
    }
}
