cc.Class({
    extends: cc.Component,

    properties: {
        label: {
            default: null,
            type: cc.Label
        },
        // defaults, set visually when attaching this script to the Canvas
        text: 'Hello, World!',

        targetCanvas: cc.Canvas,
        _cacheR: 0,
    },

    // use this for initialization
    onLoad: function () {
        this.label.string = this.text;
    },

    // called every frame
    update: function (dt) {

        const size = cc.view.getFrameSize();
        // const size = cc.visibleRect;
        this.label.string = size.width + ',' + size.height;
        let r = size.width / size.height;
        if (this._cacheR === r)
            return;

        if (r <= 1) {
            this.targetCanvas.fitHeight = false;
            this.targetCanvas.fitWidth = true;
        } else {
            this.targetCanvas.fitHeight = true;
            this.targetCanvas.fitWidth = true;
        }
        this._cacheR = r;
    },
});
