// Learn TypeScript:
//  - [Chinese] https://docs.cocos.com/creator/manual/zh/scripting/typescript.html
//  - [English] http://www.cocos2d-x.org/docs/creator/manual/en/scripting/typescript.html
// Learn Attribute:
//  - [Chinese] https://docs.cocos.com/creator/manual/zh/scripting/reference/attributes.html
//  - [English] http://www.cocos2d-x.org/docs/creator/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - [Chinese] https://docs.cocos.com/creator/manual/zh/scripting/life-cycle-callbacks.html
//  - [English] http://www.cocos2d-x.org/docs/creator/manual/en/scripting/life-cycle-callbacks.html

const { ccclass, property } = cc._decorator;

@ccclass
export default class NewClass extends cc.Component {
    @property({
        type: cc.AudioClip
    })
    bgAudio: cc.AudioClip;
    audioid;
    playState: boolean = true;
    action;
    onLoad() {
        cc.game.addPersistRootNode(this.node);
        this.autoAudioPlay();
    }
    autoAudioPlay = () => {
        this.audioid = cc.audioEngine.play(this.bgAudio, true, 1)
        this.action = cc.repeatForever(cc.rotateBy(3, 360));
        this.node.runAction(this.action);
    }
    playSwitch = () => {
        if (this.playState) {
            this.playState = false;
            // 停止一个动作
            this.node.stopAction(this.action);
            cc.audioEngine.pause(this.audioid);
            cc.loader.loadRes("musicStop", cc.SpriteFrame,(err, spriteFrame)=> {
                this.node.getComponent(cc.Sprite).spriteFrame = spriteFrame;
            });
        } else {
            this.playState = true;
            // 执行动作
            this.node.runAction(this.action);
            cc.audioEngine.resume(this.audioid);
            cc.loader.loadRes("music", cc.SpriteFrame,(err, spriteFrame)=> {
                this.node.getComponent(cc.Sprite).spriteFrame = spriteFrame;
            });
        }
    }
    onDestroy() {

    }
}
