(function() {"use strict";var __module = CC_EDITOR ? module : {exports:{}};var __filename = 'preview-scripts/assets/Script/Controller/GameController.js';var __require = CC_EDITOR ? function (request) {return cc.require(request, require);} : function (request) {return cc.require(request, __filename);};function __define (exports, require, module) {"use strict";
cc._RF.push(module, '14af9i9+b1MDZsK43l8dvSj', 'GameController', __filename);
// Script/Controller/GameController.ts

Object.defineProperty(exports, "__esModule", { value: true });
var GridView_1 = require("../View/GridView");
var GameModel_1 = require("../Model/GameModel");
var ConstValue_1 = require("../Model/ConstValue");
var Utils_1 = require("../Tools/Utils");
var _a = cc._decorator, ccclass = _a.ccclass, property = _a.property;
var axios_1 = require("../Tools/axios");
var Message = require('../Tools/message');
/**
 * 游戏控制器
 */
var GameController = /** @class */ (function (_super) {
    __extends(GameController, _super);
    function GameController() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.progress = 0;
        _this.playCode = '';
        return _this;
    }
    GameController.prototype.onLoad = function () {
        // init logic
    };
    /**
     * 提交得分
     */
    GameController.prototype.publishScores = function () {
        return __awaiter(this, void 0, void 0, function () {
            var gridView, arr, obj, i, counts;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        gridView = this.grid.getComponent(GridView_1.default);
                        return [4 /*yield*/, Utils_1.GameUtils.sleep(200)];
                    case 1:
                        _a.sent();
                        _a.label = 2;
                    case 2:
                        if (!(gridView.playAniTime !== 0 && gridView.isInPlayAni && !gridView.isCanMove)) return [3 /*break*/, 4];
                        return [4 /*yield*/, Utils_1.GameUtils.sleep(gridView.playAniTime * 1000)];
                    case 3:
                        _a.sent();
                        return [3 /*break*/, 2];
                    case 4: return [4 /*yield*/, Utils_1.GameUtils.sleep(200)];
                    case 5:
                        _a.sent();
                        arr = [];
                        obj = this.getScores();
                        for (i in obj) {
                            arr.push(obj[i]);
                        }
                        counts = arr.filter(function (item, index) {
                            return index !== 0 && index < 6;
                        });
                        Message.show('结果提交中');
                        axios_1.default.post(window['hostName'] + "/app/games/" + window['activityId'] + "/players/" + window['openid'] + "/play-over", {
                            playCode: this.playCode, scoreMeta: { counts: counts }
                        }).then(function (_a) {
                            var data = _a.data;
                            Message.hide();
                            window['score'] = data.score;
                            window['Maxscore'] = data.playerHighestScore;
                            window['rank'] = data.playerRank;
                            cc.director.loadScene("resultGame");
                        }).catch(function (error) {
                            Message.hide();
                            alert(error.response.data.message);
                        });
                        return [2 /*return*/];
                }
            });
        });
    };
    /**
     * 选中方块
     * @param pos
     */
    GameController.prototype.selectCell = function (pos) {
        return this.gameModel.selectCell(pos);
    };
    /**
     * 清理特效序列
     */
    GameController.prototype.cleanCmd = function () {
        this.gameModel.cleanCmd();
    };
    GameController.prototype.getScores = function () {
        return this.gameModel.scores;
    };
    GameController.prototype.update = function (dt) {
        // this.updateView()
    };
    GameController.prototype.addScore = function (cellView) {
        this.gameModel.addScore(cellView.model);
    };
    GameController.prototype.getCellCreateTypes = function () {
        return this.gameModel.cellCreateType;
    };
    /**
     * 设置进度
     * @param progress
     */
    GameController.prototype.setProgress = function (progress) {
        var pb = this.progressBar.getComponent(cc.ProgressBar);
        pb.progress = progress;
    };
    /**
     * 开始游戏
     */
    GameController.prototype.startGame = function (playCode, block, MAX_STEPS) {
        var _this = this;
        this.playCode = playCode;
        this.gameModel = new GameModel_1.GameModel();
        this.gameModel.init(ConstValue_1.TYPE_NUM, block);
        // this.gameModel.setCrushCallback(cycle => {
        //     if (cycle === 0) {
        //         this.gameModel.clearGuide();
        //         this.setProgress(++this.progress / MAX_STEPS);
        //     }
        //     if (this.progress === MAX_STEPS) {
        //         this.endGame();
        //     }
        // });
        var gridScript = this.grid.getComponent(GridView_1.default);
        gridScript.setController(this);
        gridScript.initWithCellModels(this.gameModel.getCells());
        this.grid.getComponent(GridView_1.default).setListener();
        this.callback = function () {
            _this.setProgress(++_this.progress / MAX_STEPS);
            _this.timer.string = (MAX_STEPS - _this.progress) <= 0 ? '0s' : (MAX_STEPS - _this.progress) + 's';
            if (_this.progress > MAX_STEPS) {
                _this.endGame();
                _this.grid.getComponent(GridView_1.default).unschedule(_this.callback);
            }
        };
        this.grid.getComponent(GridView_1.default).schedule(this.callback, 1);
    };
    /**
     * 结束游戏
     */
    GameController.prototype.endGame = function () {
        this.grid.getComponent(GridView_1.default).unsetListener();
        this.publishScores();
    };
    __decorate([
        property({
            type: cc.Node
        })
    ], GameController.prototype, "grid", void 0);
    __decorate([
        property({
            type: cc.Node
        })
    ], GameController.prototype, "dashboard", void 0);
    __decorate([
        property({
            type: cc.Node
        })
    ], GameController.prototype, "progressBar", void 0);
    __decorate([
        property({
            type: cc.Label
        })
    ], GameController.prototype, "timer", void 0);
    GameController = __decorate([
        ccclass
    ], GameController);
    return GameController;
}(cc.Component));
exports.default = GameController;

cc._RF.pop();
        }
        if (CC_EDITOR) {
            __define(__module.exports, __require, __module);
        }
        else {
            cc.registerModuleFunc(__filename, function () {
                __define(__module.exports, __require, __module);
            });
        }
        })();
        //# sourceMappingURL=GameController.js.map
        