(function() {"use strict";var __module = CC_EDITOR ? module : {exports:{}};var __filename = 'preview-scripts/assets/Script/Model/CellModel.js';var __require = CC_EDITOR ? function (request) {return cc.require(request, require);} : function (request) {return cc.require(request, __filename);};function __define (exports, require, module) {"use strict";
cc._RF.push(module, 'f65b5AtV9FEMbJYTYJkiCET', 'CellModel', __filename);
// Script/Model/CellModel.ts

Object.defineProperty(exports, "__esModule", { value: true });
var ConstValue_1 = require("./ConstValue");
/**
 * 方块数据模型
 */
var CellModel = /** @class */ (function () {
    function CellModel() {
        this.type = null;
        this.status = ConstValue_1.CELL_STATUS.COMMON;
        this.x = 1;
        this.y = 1;
        this.startX = 1;
        this.startY = 1;
        this.cmd = [];
        this.isDeath = false;
        this.round = 0;
        this.isGuide = false;
        this.isInitialized = false;
    }
    CellModel.prototype.init = function (type) {
        this.type = type;
        this.isInitialized = true;
    };
    CellModel.prototype.isEmpty = function () {
        return this.type == ConstValue_1.CELL_TYPE.EMPTY;
    };
    CellModel.prototype.setEmpty = function () {
        this.type = ConstValue_1.CELL_TYPE.EMPTY;
    };
    CellModel.prototype.setXY = function (p) {
        this.x = p.x;
        this.y = p.y;
    };
    CellModel.prototype.setStartXY = function (p) {
        this.startX = p.x;
        this.startY = p.y;
    };
    CellModel.prototype.setStatus = function (status) {
        this.status = status;
    };
    /**
     * 移动并返回
     * @param pos 目标坐标
     */
    CellModel.prototype.moveToAndBack = function (pos) {
        var srcPos = cc.p(this.x, this.y);
        this.cmd.push({
            action: "moveTo",
            keepTime: ConstValue_1.ANITIME.TOUCH_MOVE,
            playTime: 0,
            pos: pos
        });
        this.cmd.push({
            action: "moveTo",
            keepTime: ConstValue_1.ANITIME.TOUCH_MOVE,
            playTime: ConstValue_1.ANITIME.TOUCH_MOVE,
            pos: srcPos
        });
    };
    /**
     * 移动
     * @param pos 目标坐标
     * @param playTime 动画时间
     */
    CellModel.prototype.moveTo = function (pos, playTime) {
        this.cmd.push({
            action: "moveTo",
            keepTime: ConstValue_1.ANITIME.TOUCH_MOVE,
            playTime: playTime,
            pos: pos
        });
        this.x = pos.x;
        this.y = pos.y;
    };
    /**
     * 去死
     * @param playTime 动画时间
     */
    CellModel.prototype.toDie = function (playTime) {
        this.cmd.push({
            action: "toDie",
            playTime: playTime,
            keepTime: ConstValue_1.ANITIME.DIE
        });
        this.isDeath = true;
    };
    /**
     * 抖动
     * @param playTime 动画时间
     */
    CellModel.prototype.toShake = function (playTime) {
        this.cmd.push({
            action: "toShake",
            playTime: playTime,
            keepTime: ConstValue_1.ANITIME.DIE_SHAKE
        });
    };
    /**
     * 设置是否显示
     * @param playTime 动画时间
     * @param isVisible 是否显示
     */
    CellModel.prototype.setVisible = function (playTime, isVisible) {
        this.cmd.push({
            action: "setVisible",
            playTime: playTime,
            keepTime: 0,
            isVisible: isVisible
        });
    };
    CellModel.prototype.moveToAndDie = function (pos) {
    };
    CellModel.prototype.isBird = function () {
        return this.type == ConstValue_1.CELL_TYPE.BIRD;
    };
    return CellModel;
}());
exports.CellModel = CellModel;

cc._RF.pop();
        }
        if (CC_EDITOR) {
            __define(__module.exports, __require, __module);
        }
        else {
            cc.registerModuleFunc(__filename, function () {
                __define(__module.exports, __require, __module);
            });
        }
        })();
        //# sourceMappingURL=CellModel.js.map
        