(function() {"use strict";var __module = CC_EDITOR ? module : {exports:{}};var __filename = 'preview-scripts/assets/Script/Tools/Utils.js';var __require = CC_EDITOR ? function (request) {return cc.require(request, require);} : function (request) {return cc.require(request, __filename);};function __define (exports, require, module) {"use strict";
cc._RF.push(module, '6dc39Xlw05BFoS6QnT9fwoe', 'Utils', __filename);
// Script/Tools/Utils.ts

Object.defineProperty(exports, "__esModule", { value: true });
var CellModel_1 = require("../Model/CellModel");
/**
 * 工具包
 */
var GameUtils;
(function (GameUtils) {
    /**
     * 是否在数组
     * @param array
     * @param object
     */
    function isInArray(array, object) {
        var i = array.filter(function (o) {
            if (o instanceof cc.Vec2 && object instanceof cc.Vec2) {
                return o.x === object.x && o.y === object.y;
            }
            if (o instanceof CellModel_1.CellModel && object instanceof CellModel_1.CellModel) {
                return o.x === object.x && o.y === object.y;
            }
            return o === object;
        });
        return i.length > 0;
    }
    GameUtils.isInArray = isInArray;
    /**
     * 合并为新的数组，去重
     * @param arrayA
     * @param arrayB
     */
    function mergeArray(arrayA, arrayB) {
        var result = arrayA.slice();
        arrayB.forEach(function (o) {
            if (!GameUtils.isInArray(result, o)) {
                result.push(o);
            }
        });
        return result;
    }
    GameUtils.mergeArray = mergeArray;
    /**
     * 添加到数组，去重
     * @param array
     * @param object
     */
    function addToArray(array, object) {
        if (!GameUtils.isInArray(array, object))
            array.push(object);
        return array;
    }
    GameUtils.addToArray = addToArray;
    /**
     * 随机一个整数
     * @param max 最大整数，不含
     */
    function randomInt(max) {
        if (max === void 0) { max = 1000; }
        return Math.floor(Math.random() * max);
    }
    GameUtils.randomInt = randomInt;
    /**
     * 是否为空
     * @param o
     */
    function isEmpty(o) {
        if (o === null) {
            return true;
        }
        if (o === "") {
            return true;
        }
        if (o instanceof Array && o.length === 0) {
            return true;
        }
        return false;
    }
    GameUtils.isEmpty = isEmpty;
    /**
     * 延迟
     * @param ms 毫秒
     */
    function sleep(ms) {
        return new Promise(function (resolve, reject) {
            setTimeout(function () {
                resolve();
            }, ms);
        });
    }
    GameUtils.sleep = sleep;
})(GameUtils = exports.GameUtils || (exports.GameUtils = {}));

cc._RF.pop();
        }
        if (CC_EDITOR) {
            __define(__module.exports, __require, __module);
        }
        else {
            cc.registerModuleFunc(__filename, function () {
                __define(__module.exports, __require, __module);
            });
        }
        })();
        //# sourceMappingURL=Utils.js.map
        