(function() {"use strict";var __module = CC_EDITOR ? module : {exports:{}};var __filename = 'preview-scripts/assets/Script/View/CellView.js';var __require = CC_EDITOR ? function (request) {return cc.require(request, require);} : function (request) {return cc.require(request, __filename);};function __define (exports, require, module) {"use strict";
cc._RF.push(module, '5e221vUghlGRqRP5K/O61XA', 'CellView', __filename);
// Script/View/CellView.ts

Object.defineProperty(exports, "__esModule", { value: true });
var ConstValue_1 = require("../Model/ConstValue");
var Utils_1 = require("../Tools/Utils");
var _a = cc._decorator, ccclass = _a.ccclass, property = _a.property;
var CellView = /** @class */ (function (_super) {
    __extends(CellView, _super);
    function CellView() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    CellView.prototype.onLoad = function () {
        // init logic
        this.isSelect = false;
    };
    CellView.prototype.update = function (dt) {
        this.highlightSwitch(this.model.isGuide);
    };
    CellView.prototype.highlightSwitch = function (s) {
        var ice = this.node.getChildByName("ice");
        var highlight = ice.getChildByName("highlight");
        highlight.active = s;
        if (this.highlightAction && !s) {
            ice.stopAction(this.highlightAction);
            this.highlightAction = null;
            ice.runAction(cc.sequence([
                cc.scaleTo(0.1, 1),
                cc.rotateTo(0.1, 0, 0)
            ]));
        }
        else if (!this.highlightAction && s) {
            this.highlightAction = ice.runAction(cc.repeatForever(cc.sequence([
                cc.scaleTo(0.1, 1.15),
                cc.rotateBy(0.1, 10),
                cc.rotateBy(0.1, -20),
                cc.rotateBy(0.1, 20),
                cc.rotateBy(0.1, -10),
                cc.scaleTo(0.1, 1),
                cc.delayTime(0.8)
            ])));
        }
    };
    CellView.prototype.initWithModel = function (model) {
        this.model = model;
        var x = model.startX;
        var y = model.startY;
        var pos = this.transPos(x, y);
        this.node.position = pos;
        // let animation = this.node.getComponent(cc.Animation);
        // if (model.status === CELL_STATUS.COMMON) {
        //     animation.stop();
        // } else {
        //     // cc.log("play", CELL_STATUS[model.status].toLowerCase())
        //     animation.play(CELL_STATUS[model.status].toLowerCase());
        // }
    };
    CellView.prototype.setController = function (controller) {
        this.controller = controller;
    };
    CellView.prototype.transPos = function (x, y) {
        return cc.p(ConstValue_1.CELL_WIDTH * x + ConstValue_1.CELL_ROW_MARGIN + ConstValue_1.WIDTH_OFFSET, ConstValue_1.CELL_HEIGHT * y + ConstValue_1.CELL_COL_MARGIN + ConstValue_1.HEIGHT_OFFSET);
    };
    /**
     * 更新View
     * 执行CellModel#cmd中的动画序列
     */
    CellView.prototype.updateView = function () {
        var _this = this;
        var cmd = this.model.cmd;
        if (cmd.length <= 0) {
            return;
        }
        var actionArray = [];
        var curTime = 0;
        var _loop_1 = function (c) {
            if (c.playTime > curTime) {
                var delay = cc.delayTime(c.playTime - curTime);
                actionArray.push(delay);
            }
            if (c.action == "moveTo") {
                var pos = this_1.transPos(c.pos.x, c.pos.y);
                var move = cc.moveTo(ConstValue_1.ANITIME.TOUCH_MOVE, pos);
                actionArray.push(move);
            }
            else if (c.action == "toDie") {
                // if (this.status == CELL_STATUS.BIRD) {
                //     let animation = this.node.getComponent(cc.Animation);
                //     animation.play("effect");
                //     actionArray.push(cc.delayTime(ANITIME.BOMB_BIRD_DELAY));
                // }
                var callFunc = cc.callFunc(function () {
                    _this.node.destroy();
                    _this.controller.addScore(_this);
                });
                actionArray.push(callFunc);
            }
            else if (c.action == "setVisible") {
                var isVisible_1 = c.isVisible;
                actionArray.push(cc.callFunc(function () {
                    if (isVisible_1) {
                        _this.node.opacity = 255;
                    }
                    else {
                        _this.node.opacity = 0;
                    }
                }));
            }
            else if (c.action == "toShake") {
                actionArray.push(cc.rotateBy(ConstValue_1.ANITIME.DIE_SHAKE, 360));
            }
            curTime = c.playTime + c.keepTime;
        };
        var this_1 = this;
        for (var _i = 0, cmd_1 = cmd; _i < cmd_1.length; _i++) {
            var c = cmd_1[_i];
            _loop_1(c);
        }
        if (!Utils_1.GameUtils.isEmpty(actionArray)) {
            // cc.log("actionArray", actionArray)
            if (actionArray.length === 1) {
                return this.node.runAction(actionArray[0]);
            }
            else {
                return this.node.runAction(cc.sequence(actionArray));
            }
        }
    };
    /**
     * 设置选中状态
     * @param flag
     */
    CellView.prototype.setSelect = function (flag) {
        // let animation = this.node.getComponent(cc.Animation);
        var bg = this.node.getChildByName("select");
        // if (!flag && this.isSelect && this.model.status == CELL_STATUS.COMMON) {
        //     animation.stop();
        //     this.node.getComponent(cc.Sprite).spriteFrame = this.defaultFrame;
        // } else if (flag && this.model.status == CELL_STATUS.COMMON) {
        //     animation.play(CELL_STATUS[CELL_STATUS.CLICK].toLowerCase());
        // } else if (flag && this.model.status == CELL_STATUS.BIRD) {
        //     animation.play(CELL_STATUS[CELL_STATUS.CLICK].toLowerCase());
        // }
        bg.active = flag;
        this.isSelect = flag;
    };
    __decorate([
        property({
            type: cc.SpriteFrame
        })
    ], CellView.prototype, "defaultFrame", void 0);
    CellView = __decorate([
        ccclass
    ], CellView);
    return CellView;
}(cc.Component));
exports.default = CellView;

cc._RF.pop();
        }
        if (CC_EDITOR) {
            __define(__module.exports, __require, __module);
        }
        else {
            cc.registerModuleFunc(__filename, function () {
                __define(__module.exports, __require, __module);
            });
        }
        })();
        //# sourceMappingURL=CellView.js.map
        