(function() {"use strict";var __module = CC_EDITOR ? module : {exports:{}};var __filename = 'preview-scripts/assets/Script/View/EffectLayer.js';var __require = CC_EDITOR ? function (request) {return cc.require(request, require);} : function (request) {return cc.require(request, __filename);};function __define (exports, require, module) {"use strict";
cc._RF.push(module, 'f6a66r4sAFJkLedR4DNO0TB', 'EffectLayer', __filename);
// Script/View/EffectLayer.ts

Object.defineProperty(exports, "__esModule", { value: true });
var ConstValue_1 = require("../Model/ConstValue");
var _a = cc._decorator, ccclass = _a.ccclass, property = _a.property;
var EffectLayer = /** @class */ (function (_super) {
    __extends(EffectLayer, _super);
    function EffectLayer() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    EffectLayer.prototype.onLoad = function () {
        // init logic
    };
    EffectLayer.prototype.playEffects = function (effectQueue) {
        var _this = this;
        if (!effectQueue || effectQueue.length <= 0) {
            return;
        }
        var _loop_1 = function (cmd) {
            var delayTime = cc.delayTime(cmd.playTime);
            var callFunc = cc.callFunc(function () {
                var instantEffect = null;
                var animation = null;
                if (cmd.action == "crush") {
                    instantEffect = cc.instantiate(_this.crushEffect);
                    animation = instantEffect.getComponent(cc.Animation);
                    animation.play("effect");
                    // } else if (cmd.action == "rowBomb") {
                    //     instantEffect = cc.instantiate(this.bombWhite);
                    //     animation = instantEffect.getComponent(cc.Animation);
                    //     animation.play("effect_line");
                    // } else if (cmd.action == "colBomb") {
                    //     instantEffect = cc.instantiate(this.bombWhite);
                    //     animation = instantEffect.getComponent(cc.Animation);
                    //     animation.play("effect_col");
                }
                else {
                    return;
                }
                instantEffect.x = ConstValue_1.CELL_WIDTH * (cmd.pos.x - 0.5) + ConstValue_1.WIDTH_OFFSET;
                instantEffect.y = ConstValue_1.CELL_WIDTH * (cmd.pos.y - 0.5) + ConstValue_1.HEIGHT_OFFSET;
                instantEffect.parent = _this.node;
                animation.on("finished", function () {
                    instantEffect.destroy();
                });
            });
            this_1.node.runAction(cc.sequence(delayTime, callFunc));
        };
        var this_1 = this;
        for (var _i = 0, effectQueue_1 = effectQueue; _i < effectQueue_1.length; _i++) {
            var cmd = effectQueue_1[_i];
            _loop_1(cmd);
        }
    };
    __decorate([
        property({
            default: null,
            type: cc.Prefab
        })
    ], EffectLayer.prototype, "crushEffect", void 0);
    EffectLayer = __decorate([
        ccclass
    ], EffectLayer);
    return EffectLayer;
}(cc.Component));
exports.default = EffectLayer;

cc._RF.pop();
        }
        if (CC_EDITOR) {
            __define(__module.exports, __require, __module);
        }
        else {
            cc.registerModuleFunc(__filename, function () {
                __define(__module.exports, __require, __module);
            });
        }
        })();
        //# sourceMappingURL=EffectLayer.js.map
        