(function() {"use strict";var __module = CC_EDITOR ? module : {exports:{}};var __filename = 'preview-scripts/assets/Script/View/GridView.js';var __require = CC_EDITOR ? function (request) {return cc.require(request, require);} : function (request) {return cc.require(request, __filename);};function __define (exports, require, module) {"use strict";
cc._RF.push(module, 'a0e98M2Q0lPwapg9ZiGHyjZ', 'GridView', __filename);
// Script/View/GridView.ts

Object.defineProperty(exports, "__esModule", { value: true });
var CellView_1 = require("./CellView");
var ConstValue_1 = require("../Model/ConstValue");
var EffectLayer_1 = require("./EffectLayer");
var _a = cc._decorator, ccclass = _a.ccclass, property = _a.property;
var GridView = /** @class */ (function (_super) {
    __extends(GridView, _super);
    function GridView() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.aniPre = [];
        _this.playAniTime = 0;
        return _this;
    }
    GridView.prototype.onLoad = function () {
        // init logic
        // this.setListener();
        this.lastTouchPos = cc.p(-1, -1);
        this.isCanMove = true;
        this.isInPlayAni = false; // 是否在播放中
    };
    GridView.prototype.setController = function (controller) {
        this.controller = controller;
    };
    /**
     * 初始化
     * @param cellsModels
     */
    GridView.prototype.initWithCellModels = function (cellsModels) {
        this.cellViews = [];
        for (var i = 1; i <= ConstValue_1.GRID_HEIGHT; i++) {
            this.cellViews[i] = [];
            for (var j = 1; j <= ConstValue_1.GRID_WIDTH; j++) {
                var type = cellsModels[i][j].type;
                var aniView = cc.instantiate(this.aniPre[type]);
                aniView.parent = this.node;
                var cellViewScript = aniView.getComponent(CellView_1.default);
                cellViewScript.setController(this.controller);
                cellViewScript.initWithModel(cellsModels[i][j]);
                this.cellViews[i][j] = aniView;
            }
        }
    };
    /**
     * 设置事件监听
     */
    GridView.prototype.setListener = function () {
        this.node.on(cc.Node.EventType.TOUCH_START, this.onTouchStart, this);
        this.node.on(cc.Node.EventType.TOUCH_MOVE, this.onTouchMove, this);
        // this.node.on(cc.Node.EventType.TOUCH_END, (eventTouch: cc.Event.EventTouch) => {
        //     // console.log("1111");
        // });
        // this.node.on(cc.Node.EventType.TOUCH_CANCEL, (eventTouch: cc.Event.EventTouch) => {
        //     // console.log("1111");
        // });
    };
    /**
     * 注销事件监听
     */
    GridView.prototype.unsetListener = function () {
        this.node.off(cc.Node.EventType.TOUCH_START, this.onTouchStart, this);
        this.node.off(cc.Node.EventType.TOUCH_MOVE, this.onTouchMove, this);
    };
    GridView.prototype.onTouchStart = function (eventTouch) {
        if (this.isInPlayAni) {
            return true;
        }
        var touchPos = eventTouch.getLocation();
        var cellPos = this.convertTouchPosToCell(touchPos);
        if (cellPos) {
            var changeModels = this.selectCell(cellPos);
            if (changeModels.length >= 3) {
                this.isCanMove = false;
            }
            else {
                this.isCanMove = true;
            }
        }
        else {
            this.isCanMove = false;
        }
        return true;
    };
    GridView.prototype.onTouchMove = function (eventTouch) {
        if (this.isCanMove) {
            var startTouchPos = eventTouch.getStartLocation();
            var startCellPos = this.convertTouchPosToCell(startTouchPos);
            var touchPos = eventTouch.getLocation();
            var cellPos = this.convertTouchPosToCell(touchPos);
            if (cellPos && startCellPos && startCellPos.x != cellPos.x || startCellPos.y != cellPos.y) {
                this.isCanMove = false;
                this.selectCell(cellPos);
            }
        }
    };
    /**
     * 坐标转换
     * @param pos
     */
    GridView.prototype.convertTouchPosToCell = function (pos) {
        pos = this.node.convertToNodeSpace(pos);
        if (pos.x < ConstValue_1.WIDTH_OFFSET || pos.x >= ConstValue_1.GRID_PIXEL_WIDTH + ConstValue_1.WIDTH_OFFSET * 2 || pos.y < ConstValue_1.HEIGHT_OFFSET || pos.y >= ConstValue_1.GRID_PIXEL_HEIGHT + ConstValue_1.HEIGHT_OFFSET * 2) {
            return null;
        }
        var x = Math.floor((pos.x - ConstValue_1.WIDTH_OFFSET) / ConstValue_1.CELL_WIDTH) + 1;
        var y = Math.floor((pos.y - ConstValue_1.HEIGHT_OFFSET) / ConstValue_1.CELL_HEIGHT) + 1;
        return cc.p(x, y);
    };
    /**
     * 更新View
     * @param changeModels
     */
    GridView.prototype.updateView = function (changeModels) {
        var newCellViewInfo = [];
        for (var _i = 0, changeModels_1 = changeModels; _i < changeModels_1.length; _i++) {
            var model = changeModels_1[_i];
            var viewInfo = this.findViewByModel(model);
            var view = null;
            if (!viewInfo) {
                var type = model.type;
                var aniView = cc.instantiate(this.aniPre[type]);
                aniView.parent = this.node;
                var cellViewScript = aniView.getComponent(CellView_1.default);
                cellViewScript.setController(this.controller);
                cellViewScript.initWithModel(model);
                view = aniView;
            }
            else {
                view = viewInfo.view;
                this.cellViews[viewInfo.y][viewInfo.x] = null;
            }
            var cellScript = view.getComponent(CellView_1.default);
            cellScript.updateView();
            if (!model.isDeath) {
                newCellViewInfo.push({
                    model: model,
                    view: view
                });
            }
        }
        for (var _a = 0, newCellViewInfo_1 = newCellViewInfo; _a < newCellViewInfo_1.length; _a++) {
            var ele = newCellViewInfo_1[_a];
            var model = ele.model;
            this.cellViews[model.y][model.x] = ele.view;
        }
    };
    /**
     * 更新选中
     * @param pos
     */
    GridView.prototype.updateSelect = function (pos) {
        for (var i = 1; i <= ConstValue_1.GRID_HEIGHT; i++) {
            for (var j = 1; j <= ConstValue_1.GRID_WIDTH; j++) {
                if (this.cellViews[i][j]) {
                    var cellScript = this.cellViews[i][j].getComponent(CellView_1.default);
                    if (pos.x == j && pos.y == i) {
                        cellScript.setSelect(true);
                    }
                    else {
                        cellScript.setSelect(false);
                    }
                }
            }
        }
    };
    /**
     * 查询View
     * @param model
     */
    GridView.prototype.findViewByModel = function (model) {
        for (var i = 1; i <= ConstValue_1.GRID_HEIGHT; i++) {
            for (var j = 1; j <= ConstValue_1.GRID_WIDTH; j++) {
                if (this.cellViews[i][j] && this.cellViews[i][j].getComponent(CellView_1.default).model == model) {
                    return { view: this.cellViews[i][j], x: j, y: i };
                }
            }
        }
        return null;
    };
    /**
     * 获取动画时间
     * @param changeModels
     */
    GridView.prototype.getPlayAniTime = function (changeModels) {
        if (!changeModels) {
            return 0;
        }
        var maxTime = 0;
        for (var _i = 0, changeModels_2 = changeModels; _i < changeModels_2.length; _i++) {
            var ele = changeModels_2[_i];
            for (var _a = 0, _b = ele.cmd; _a < _b.length; _a++) {
                var cmd = _b[_a];
                if (maxTime < cmd.playTime + cmd.keepTime) {
                    maxTime = cmd.playTime + cmd.keepTime;
                }
            }
        }
        return maxTime;
    };
    /**
     * 禁止触控
     * @param time 禁止时长
     */
    GridView.prototype.disableTouch = function (time) {
        var _this = this;
        if (time <= 0) {
            return;
        }
        this.isInPlayAni = true;
        this.node.runAction(cc.sequence(cc.delayTime(time), cc.callFunc(function () { return _this.isInPlayAni = false; })));
    };
    /**
     * 选中方块
     * @param cellPos
     */
    GridView.prototype.selectCell = function (cellPos) {
        var _a = this.controller.selectCell(cellPos), changeModels = _a[0], effectsQueue = _a[1];
        this.playAniTime = this.getPlayAniTime(changeModels);
        this.playEffect(effectsQueue);
        this.disableTouch(this.playAniTime);
        this.updateView(changeModels);
        this.controller.cleanCmd();
        if (changeModels.length >= 2) {
            this.updateSelect(cc.p(-1, -1));
        }
        else {
            this.updateSelect(cellPos);
        }
        return changeModels;
    };
    /**
     * 播放特效
     * @param effectsQueue
     */
    GridView.prototype.playEffect = function (effectsQueue) {
        this.effectLayer.getComponent(EffectLayer_1.default).playEffects(effectsQueue);
    };
    __decorate([
        property({
            type: [cc.Prefab]
        })
    ], GridView.prototype, "aniPre", void 0);
    __decorate([
        property({
            type: cc.Node
        })
    ], GridView.prototype, "effectLayer", void 0);
    GridView = __decorate([
        ccclass
    ], GridView);
    return GridView;
}(cc.Component));
exports.default = GridView;

cc._RF.pop();
        }
        if (CC_EDITOR) {
            __define(__module.exports, __require, __module);
        }
        else {
            cc.registerModuleFunc(__filename, function () {
                __define(__module.exports, __require, __module);
            });
        }
        })();
        //# sourceMappingURL=GridView.js.map
        