(function() {"use strict";var __module = CC_EDITOR ? module : {exports:{}};var __filename = 'preview-scripts/assets/Script/formGame.js';var __require = CC_EDITOR ? function (request) {return cc.require(request, require);} : function (request) {return cc.require(request, __filename);};function __define (exports, require, module) {"use strict";
cc._RF.push(module, 'c38c6G2vE9M2reNGOYN7vzH', 'formGame', __filename);
// Script/formGame.ts

Object.defineProperty(exports, "__esModule", { value: true });
// Learn TypeScript:
//  - [Chinese] https://docs.cocos.com/creator/manual/zh/scripting/typescript.html
//  - [English] http://www.cocos2d-x.org/docs/creator/manual/en/scripting/typescript.html
// Learn Attribute:
//  - [Chinese] https://docs.cocos.com/creator/manual/zh/scripting/reference/attributes.html
//  - [English] http://www.cocos2d-x.org/docs/creator/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - [Chinese] https://docs.cocos.com/creator/manual/zh/scripting/life-cycle-callbacks.html
//  - [English] http://www.cocos2d-x.org/docs/creator/manual/en/scripting/life-cycle-callbacks.html
var axios_1 = require("./Tools/axios");
var Message = require('./Tools/message');
var _a = cc._decorator, ccclass = _a.ccclass, property = _a.property;
var NewClass = /** @class */ (function (_super) {
    __extends(NewClass, _super);
    function NewClass() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    // LIFE-CYCLE CALLBACKS:
    // onLoad () {}
    NewClass.prototype.start = function () {
    };
    NewClass.prototype.submit = function () {
        var _this = this;
        var reg = /^(13[0-9]|14[5|7]|15[0|1|2|3|5|6|7|8|9]|18[0|1|2|3|5|6|7|8|9])\d{8}$/;
        var name = this.userName.string;
        var phone = this.phone.string;
        var address = this.address.string;
        if (name.length === 0) {
            this.error.string = '请输入姓名';
            return;
        }
        if (phone.length === 0 || (phone.length !== 0 && !reg.test(phone))) {
            this.error.string = '请输入正确格式的电话';
            return;
        }
        if (address.length === 0) {
            this.error.string = '请输入收货地址';
            return;
        }
        this.error.string = '';
        this.submitBtn.enabled = false;
        this.subLabel.string = '提交中...';
        Message.show();
        axios_1.default.put(window['hostName'] + "/app/games/" + window['activityId'] + "/players/" + window['openid'] + "/address", { phone: phone, name: name, address: address }).then(function (_a) {
            var data = _a.data;
            Message.hide();
            _this.submitBtn.enabled = true;
            _this.subLabel.string = '提交';
            _this.error.string = "提交成功";
            localStorage['relexUserInfo'] = JSON.stringify(data);
            _this.goback();
        }).catch(function (error) {
            Message.hide();
            _this.submitBtn.enabled = true;
            _this.subLabel.string = '提交';
            _this.error.string = error.response.data.message;
        });
    };
    NewClass.prototype.goback = function () {
        cc.director.loadScene(window['scene']);
    };
    __decorate([
        property(cc.EditBox)
    ], NewClass.prototype, "userName", void 0);
    __decorate([
        property(cc.EditBox)
    ], NewClass.prototype, "phone", void 0);
    __decorate([
        property(cc.EditBox)
    ], NewClass.prototype, "address", void 0);
    __decorate([
        property(cc.Label)
    ], NewClass.prototype, "error", void 0);
    __decorate([
        property(cc.Button)
    ], NewClass.prototype, "submitBtn", void 0);
    __decorate([
        property(cc.Label)
    ], NewClass.prototype, "subLabel", void 0);
    NewClass = __decorate([
        ccclass
    ], NewClass);
    return NewClass;
}(cc.Component));
exports.default = NewClass;

cc._RF.pop();
        }
        if (CC_EDITOR) {
            __define(__module.exports, __require, __module);
        }
        else {
            cc.registerModuleFunc(__filename, function () {
                __define(__module.exports, __require, __module);
            });
        }
        })();
        //# sourceMappingURL=formGame.js.map
        