(function() {"use strict";var __module = CC_EDITOR ? module : {exports:{}};var __filename = 'preview-scripts/assets/Script/resultGame.js';var __require = CC_EDITOR ? function (request) {return cc.require(request, require);} : function (request) {return cc.require(request, __filename);};function __define (exports, require, module) {"use strict";
cc._RF.push(module, '800a6yoG0BBcoL7Jm+/We1w', 'resultGame', __filename);
// Script/resultGame.ts

Object.defineProperty(exports, "__esModule", { value: true });
// Learn TypeScript:
//  - [Chinese] https://docs.cocos.com/creator/manual/zh/scripting/typescript.html
//  - [English] http://www.cocos2d-x.org/docs/creator/manual/en/scripting/typescript.html
// Learn Attribute:
//  - [Chinese] https://docs.cocos.com/creator/manual/zh/scripting/reference/attributes.html
//  - [English] http://www.cocos2d-x.org/docs/creator/manual/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - [Chinese] https://docs.cocos.com/creator/manual/zh/scripting/life-cycle-callbacks.html
//  - [English] http://www.cocos2d-x.org/docs/creator/manual/en/scripting/life-cycle-callbacks.html
var wx_1 = require("./Tools/wx");
var Message = require('./Tools/message');
var CNZZ = require('./Tools/cnnz');
var _a = cc._decorator, ccclass = _a.ccclass, property = _a.property;
var NewClass = /** @class */ (function (_super) {
    __extends(NewClass, _super);
    function NewClass() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    // LIFE-CYCLE CALLBACKS:
    NewClass.prototype.onLoad = function () {
        wx_1.default({
            isNeedLogin: true,
            title: '西瓜PK赛，悦克免费烟弹送一年',
            desc: 'RELX悦刻新口味烟弹上市啦！冰镇西瓜、清爽黄瓜、清香绿茶、点击快速领取',
            imgUrl: 'https://h5.parsec.com.cn/common/relexlogo1.png',
            link: "https://h5.parsec.com.cn/cancellation?shareCode=" + encodeURIComponent(JSON.parse(localStorage['relexUserInfo']).shareCode)
        });
        this.score.string = "" + window['score'];
        this.Maxscore.string = "" + window['Maxscore'];
        this.rank.string = "" + window['rank'];
    };
    //填写表单
    NewClass.prototype.ToForm = function () {
        cc.director.loadScene("formGame");
    };
    //显示分享层
    NewClass.prototype.showshare = function () {
        this.sharets.active = true;
        //help
        this.sharelogo.runAction(cc.repeatForever(cc.sequence([
            cc.moveBy(0.6, cc.p(20, 20)),
            cc.moveBy(0.2, cc.p(-20, -20))
        ])));
        CNZZ.total(['_trackEvent', '结束页', '分享好友', '弹出提示']);
    };
    //关闭分享提示层
    NewClass.prototype.hideshare = function () {
        this.sharets.active = false;
    };
    //重玩一局
    NewClass.prototype.replay = function () {
        CNZZ.total(['_trackEvent', '结束页', '再来一次', '再来一次']);
        cc.director.loadScene("mainGame");
    };
    //尝鲜悦克
    NewClass.prototype.try = function () {
        window.location.href = "https://h5.youzan.com/v2/goods/1y6kiu8nor4tk?dc_ps=2262892026951567366.200001";
    };
    NewClass.prototype.creater = function () {
        var _this = this;
        Message.show('海报生成中');
        this.billCreater.active = true;
        this.result.active = false;
        this.HMaxscore.string = "" + window['Maxscore'];
        this.Hrank.string = "" + window['rank'];
        var userObj = JSON.parse(localStorage['relexUserInfo']);
        this.nickName.string = "" + userObj.nickname;
        var url = userObj.headimgurl.replace('http://thirdwx.qlogo.cn', 'https://h5.parsec.com.cn/wx-img');
        // let url='../Texture/base/btn.png'
        cc.loader.load({ url: url, type: 'png' }, function (err, res) {
            Message.hide();
            _this.headIcon.getComponent(cc.Sprite).spriteFrame = new cc.SpriteFrame(res);
            _this.createrQR();
            _this.capture();
        });
        CNZZ.total(['_trackEvent', '结束页', '生成海报', '生成海报']);
    };
    //生成二维码
    NewClass.prototype.createrQR = function () {
        var urlString = "https://h5.parsec.com.cn/cancellation?shareCode=" + encodeURIComponent(JSON.parse(localStorage['relexUserInfo']).shareCode);
        var graphics = this.qrNode.getComponent(cc.Graphics);
        // return
        graphics.clear();
        //背景色
        graphics.fillColor = cc.Color.WHITE;
        //let rect = this.node.getBoundingBox();
        var width = this.qrNode.width;
        graphics.rect(0 - width * 0.5, 0 - width * 0.5, width, width);
        graphics.fill();
        graphics.close();
        //生成二维码数据
        var qrcode = new QRCode(-1, 2);
        qrcode.addData(urlString);
        qrcode.make();
        graphics.fillColor = cc.Color.BLACK;
        var size = width - 10 * 2;
        var num = qrcode.getModuleCount();
        var tileW = size / num;
        var tileH = size / num;
        var w = Math.ceil(tileW);
        var h = Math.ceil(tileH);
        for (var row = 0; row < num; row++) {
            for (var col = 0; col < num; col++) {
                if (qrcode.isDark(row, col)) {
                    graphics.rect(10 + col * tileW - width * 0.5, size - tileH - Math.round(row * tileH) + 10 - width * 0.5, w, h);
                    graphics.fill();
                }
            }
        }
    };
    //截屏
    NewClass.prototype.capture = function () {
        cc.director.on(cc.Director.EVENT_AFTER_DRAW, this.callback.bind(this));
    };
    NewClass.prototype.callback = function () {
        var canvas = document.getElementById("GameCanvas");
        var baseUrl = canvas.toDataURL("imagea/png");
        cc.director.off(cc.Director.EVENT_AFTER_DRAW);
        this.showImgDiv(baseUrl);
    };
    //显示图片
    NewClass.prototype.showImgDiv = function (url) {
        var _this = this;
        CNZZ.total(['_trackEvent', '海报', '长按保存', '长按保存']);
        var div = document.createElement('div');
        div.setAttribute('id', 'imgmask');
        div.style.position = 'absolute';
        div.style.zIndex = '9999';
        div.style.top = "0px";
        div.style.bottom = "0px";
        div.style.left = "0px";
        div.style.right = "0px";
        div.style.backgroundColor = "rgba(0,0,0,0.7)";
        div.onclick = function () {
            _this.closeSaveImg();
        };
        div.innerHTML = "<div style=\"position:absolute;transform:translate(-50%,-50%);left:50%;top:50%;width:70%\" onclick=\"event.stopPropagation();\">\n        <img src=\"" + url + "\" style=\"width:100%;\" />\n        <div style=\"font-size:12px;color:#000;text-decoration:underline;position:absolute;bottom:3.68%;background:#f2ead3;padding:5px;left:50%;transform:translateX(-50%) scale(0.5);\">\u957F\u6309\u56FE\u7247\u8FDB\u884C\u4FDD\u5B58</div>\n        </div>";
        document.body.appendChild(div);
        this.billCreater.active = false;
        this.result.active = true;
    };
    //关闭保存
    NewClass.prototype.closeSaveImg = function () {
        var div = document.getElementById('imgmask');
        document.body.removeChild(div);
    };
    __decorate([
        property(cc.Label)
    ], NewClass.prototype, "score", void 0);
    __decorate([
        property(cc.Label)
    ], NewClass.prototype, "Maxscore", void 0);
    __decorate([
        property(cc.Label)
    ], NewClass.prototype, "rank", void 0);
    __decorate([
        property(cc.Node)
    ], NewClass.prototype, "headIcon", void 0);
    __decorate([
        property(cc.Node)
    ], NewClass.prototype, "qrNode", void 0);
    __decorate([
        property(cc.Label)
    ], NewClass.prototype, "HMaxscore", void 0);
    __decorate([
        property(cc.Label)
    ], NewClass.prototype, "Hrank", void 0);
    __decorate([
        property(cc.Label)
    ], NewClass.prototype, "nickName", void 0);
    __decorate([
        property(cc.Node)
    ], NewClass.prototype, "sharets", void 0);
    __decorate([
        property(cc.Node)
    ], NewClass.prototype, "sharelogo", void 0);
    __decorate([
        property(cc.Node)
    ], NewClass.prototype, "result", void 0);
    __decorate([
        property(cc.Node)
    ], NewClass.prototype, "billCreater", void 0);
    NewClass = __decorate([
        ccclass
    ], NewClass);
    return NewClass;
}(cc.Component));
exports.default = NewClass;

cc._RF.pop();
        }
        if (CC_EDITOR) {
            __define(__module.exports, __require, __module);
        }
        else {
            cc.registerModuleFunc(__filename, function () {
                __define(__module.exports, __require, __module);
            });
        }
        })();
        //# sourceMappingURL=resultGame.js.map
        