
const { ccclass, requireComponent, property } = cc._decorator;

@ccclass
@requireComponent(cc.Sprite)
export default class ShaderEffect extends cc.Component {

    @property({ type: cc.Material, tooltip: '材质Shader' })
    Material: cc.Material = null;
    @property({ type: cc.Float, slide: true, min: 0.01, max: 5, tooltip: '运行速度' })
    Speed: number = 1.0;

    @property({ type: cc.Float, slide: true, min: 0, max: 1, tooltip: '运行时间\n用于拖动预览' })
    set SysTime(time: number) {
        this._sin = time;
        let sprite = this.node.getComponent(cc.Sprite);
        if (sprite && this.Material) {
            if (sprite.spriteFrame) {
                this.Material.setProperty('sys_time', this.SysTime);
                sprite.setMaterial(0, this.Material);
            }
        }
    }
    get SysTime() { return this._sin;}
    
    @property({ tooltip: '循环播放' })
    Loop: boolean = true;

    _Sprite: cc.Sprite = null;
    _systime: number = 0;
    _sin: number = 0;
    _palyEnd: boolean = false;

    update(dt) {
        if (this._palyEnd) return;
        this._systime += this.Speed * dt;
        this._sin = Math.tan(this._systime);
        if (this._sin > 0.99) {
            this._sin = 0;
            this._systime = 0;
            if (!this.Loop) {
                this._palyEnd = true;
            }
        }
        this.SysTime = this._sin;
    }
}
