/**
 * @Author: kinglich
 * @Date:   2019-06-20T11:51:59+08:00
 * @Last modified by:   kinglich
 * @Last modified time: 2019-06-20T17:46:06+08:00
 */
//用户自动调节异形屏下左右 ui缩进距离
window.shapedScreenAdapt = window.shapedScreenAdapt || {};
var module = shapedScreenAdapt;
var FixedWidth = cc.Class({
    name: "FixedWidthDiy",
    extends: cc.ContentStrategy,
    apply: function (view, designedResolution) {
        var containerW = cc.game.canvas.width, containerH = cc.game.canvas.height,
            designW = designedResolution.width, scale = containerW / designW,
            contentW = containerW, contentH = containerH;

        return this._buildResult(containerW, containerH, contentW, contentH- module.sliderDis, scale, scale);
    }
});
var FixedHeight = cc.Class({
      name: "FixedHeightDiy",
      extends: cc.ContentStrategy,
      apply: function (view, designedResolution) {
          var containerW = cc.game.canvas.width, containerH = cc.game.canvas.height,
              designH = designedResolution.height, scale = containerH / designH,
              contentW = containerW, contentH = containerH;

          return this._buildResult(containerW, containerH, contentW - module.sliderDis, contentH, scale, scale);
      }
});

//初始化基础
module.init = function () {
    this.sliderPer = 0;//初始化滑动进度
    this.slider2Dis = 100;//滑动偏移像素
    this.sliderDis = this.sliderPer * this.slider2Dis;//偏移距离
};

module.getSliderDis = function () {
    return this.sliderDis;
};

module.getSliderPer = function () {
    return this.sliderPer;
};
//当前是否定宽适配
module.isFitHeight = function () {
    if (this.fitFlag === undefined) {
        this.fitFlag = cc.find("Canvas").getComponent(cc.Canvas).fitHeight;
    }
    return this.fitFlag;
};
//偷偷修改下适配方案
var hackCC = function () {
    var module = shapedScreenAdapt;
    if (module.isFitHeight()) {
        cc.ContentStrategy.FIXED_HEIGHT = new FixedHeight();
        cc.view._rpFixedHeight.setContentStrategy(cc.ContentStrategy.FIXED_HEIGHT);
    }else {
        cc.ContentStrategy.FIXED_WIDTH = new FixedWidth();
        cc.view._rpFixedWidth.setContentStrategy(cc.ContentStrategy.FIXED_WIDTH);
    }
};
//设置偏离度 0-1
module.setSliderPer = function (per) {
    if (this.sliderPer === per) return;
    this.sliderPer = per;
    this.sliderDis = Number((this.sliderPer * this.slider2Dis).toFixed(0));
    this._applySlider();
};
//读取缓存设置
module.initCache = function (){
    var str = cc.sys.localStorage.getItem('shapedScreenAdapt_Slider');
    if (!str) return;
    var sliderPer = 0;
    try {
        sliderPer = Number(str);
    } catch (e) {
        sliderPer = null;
    }
    if (sliderPer !== null) {
        this.setSliderPer(sliderPer);
    }
};
//写入缓存
module.saveCache = function () {
    cc.sys.localStorage.setItem("shapedScreenAdapt_Slider", this.sliderPer+"");
};
//应用当前的进度
module._applySlider = function () {
    var comp = cc.find("Canvas").getComponent(cc.Canvas);
    if (!comp._originaSize) {
        comp._originaSize = cc.size(comp.designResolution.width,comp.designResolution.height);
    }
    var resoultionSize = comp._originaSize;
    var reSize = null;
    if (module.isFitHeight()) {
        reSize = cc.size(resoultionSize.width - this.sliderDis,resoultionSize.height);
    }else {
        reSize = cc.size(resoultionSize.width ,resoultionSize.height - this.sliderDis);
    }
    comp.designResolution = reSize;
    cc._widgetManager.onResized()
    this.saveCache();
};

if (!CC_EDITOR) {
    module.init();

    cc.game.once(cc.game.EVENT_GAME_INITED, function () {
        cc.director.on(cc.Director.EVENT_AFTER_SCENE_LAUNCH, function () {
            hackCC();
            module.initCache();
        });
    });
}
