// Learn cc.Class:
//  - [Chinese] http://www.cocos.com/docs/creator/scripting/class.html
//  - [English] http://www.cocos2d-x.org/docs/editors_and_tools/creator-chapters/scripting/class/index.html
// Learn Attribute:
//  - [Chinese] http://www.cocos.com/docs/creator/scripting/reference/attributes.html
//  - [English] http://www.cocos2d-x.org/docs/editors_and_tools/creator-chapters/scripting/reference/attributes/index.html
// Learn life-cycle callbacks:
//  - [Chinese] http://www.cocos.com/docs/creator/scripting/life-cycle-callbacks.html
//  - [English] http://www.cocos2d-x.org/docs/editors_and_tools/creator-chapters/scripting/life-cycle-callbacks/index.html

var WebSocket = WebSocket || window.WebSocket || window.MozWebSocket;


cc.Class({
    extends: cc.Component,

    properties: {
        // foo: {
        //     // ATTRIBUTES:
        //     default: null,        // The default value will be used only when the component attaching
        //                           // to a node for the first time
        //     type: cc.SpriteFrame, // optional, default is typeof default
        //     serializable: true,   // optional, default is true
        // },
        // bar: {
        //     get () {
        //         return this._bar;
        //     },
        //     set (value) {
        //         this._bar = value;
        //     }
        // },
        l:{
            default:null,
            type: cc.Label
        }
        
    },

    // LIFE-CYCLE CALLBACKS:

    onLoad () {
        this.socket = new WebSocket("ws://192.168.8.217:9080");	
        this.socket.binaryType = "arraybuffer";
        this.socket.parent = this;

        this.socket.onopen = function(evt)
        {
            cc.log('Network onopen...');
            this.isInit = true;
        };

        this.socket.onmessage = function(evt){
            cc.log('Network onmessage...');
        };

        this.socket.onerror = function(evt){
            cc.log('Network onerror...');
        };

        this.socket.onclose = function(evt){
            cc.log('Network onclose...');
            this.isInit = false;
        };
    },

    start () {
        this.schedule(this.updateScheule, 1);
        
        cc.loader.loadRes("audio/bg3", (error, audio)=>{
            cc.audioEngine.playMusic(audio, true);
        });
    },

    // update (dt) {},

    //
    send : function(data){
        if (!this.socket.isInit){
            cc.log('Network is not inited...');
        }else if(this.socket.readyState == WebSocket.OPEN){
            cc.log('Network send:'+data);
            this.socket.send(data);
        }else{
            cc.log('Network WebSocket readState:'+ this.socket.readyState);
        }
    },
    
    close : function(){
        if (this.socket){
            log("Network close...");
            this.socket.close();
            this.socket = null;
        }
    },
    
    updateScheule : function(){
        this.l.string = "11111111111"
    },
});
