/*
 * @Author: wss 
 * @Date: 2020-03-27 00:38:10 
 * @Last Modified by: wss
 * @Last Modified time: 2020-03-27 01:01:53
 */


const { ccclass, property,executeInEditMode } = cc._decorator;

@ccclass
export default class CellItem extends cc.Component {

    @property(cc.Animation)
    anim: cc.Animation = null;

    @property(cc.Label)
    label:cc.Label = null;
    
    /**
     * 动画完成进度
     */
    @property({
        range: [0, 1],
    })
    private _progress: number = 0.5;
    @property({
        range: [0, 1],
        slide:true
    })
    public get progress(): number {
        return this._progress;
    }
    public set progress(v: number) {
        this._progress = v;
    }

    public onLoad() {
        this.anim = this.getComponent(cc.Animation);
        this.anim.play();
    }

    public init(progress:number,index:number)
    {
        this.progress = progress;
        this.label.string = "("+ index+ ")";
    }


    update (dt) {
        if (this.anim.currentClip == null) return;
        let clip = this.anim.currentClip;
        
        //[核心部分] 强制设置动画处于某一个时间节点
        this.anim.setCurrentTime( clip.duration * this._progress)
    }
}
