/*
 * @Author: wss 
 * @Date: 2020-03-27 00:38:04 
 * @Last Modified by: wss
 * @Last Modified time: 2020-03-27 01:03:31
 */


import CellItem from "./CellItem";

const { ccclass, property } = cc._decorator;

@ccclass
export default class LoopList extends cc.Component {
    onLoad() {
        this.initCells();
    }

    initCells() {
        //5个单位
        for (let i = 1; i < 5; i++) {
            let child = cc.instantiate(this.node.children[0]);
            this.node.addChild(child);
        }
        for (let i = 0; i < this.node.childrenCount; i++) {
            let child = this.node.children[i];
            //设置进度位置
            child.getComponent(CellItem).init(0.5 + i / 5, i);
        }
    }
    onEnable() {
        this.node.on(cc.Node.EventType.TOUCH_MOVE, this.onTouchMove, this);
    }

    onDisable() {
        this.node.off(cc.Node.EventType.TOUCH_MOVE, this.onTouchMove, this);

    }
    onTouchMove(event: cc.Event.EventTouch) {
        let delta = event.getDelta().x / this.node.width;

        this.node.children.forEach(child => {
            let cell = child.getComponent(CellItem);
            //因为 cell 受到动画控制，progress 只在0 ~ 1 之间，只要取1的余数就自动循环了，从而避免复杂坐标运算。
            cell.progress = (cell.progress + delta) % 1;

        })

    }

}
