
                (function() {
                    var nodeEnv = typeof require !== 'undefined' && typeof process !== 'undefined';
                    var __module = nodeEnv ? module : {exports:{}};
                    var __filename = 'preview-scripts/assets/LoopList.js';
                    var __require = nodeEnv ? function (request) {
                        return cc.require(request);
                    } : function (request) {
                        return __quick_compile_project__.require(request, __filename);
                    };
                    function __define (exports, require, module) {
                        if (!nodeEnv) {__quick_compile_project__.registerModule(__filename, module);}"use strict";
cc._RF.push(module, '79c96OmhUNFQL8Aegn+iovc', 'LoopList');
// LoopList.ts

/*
 * @Author: wss
 * @Date: 2020-03-27 00:38:04
 * @Last Modified by: wss
 * @Last Modified time: 2020-03-27 01:03:31
 */
Object.defineProperty(exports, "__esModule", { value: true });
var CellItem_1 = require("./CellItem");
var _a = cc._decorator, ccclass = _a.ccclass, property = _a.property;
var LoopList = /** @class */ (function (_super) {
    __extends(LoopList, _super);
    function LoopList() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    LoopList.prototype.onLoad = function () {
        this.initCells();
    };
    LoopList.prototype.initCells = function () {
        //5个单位
        for (var i = 1; i < 5; i++) {
            var child = cc.instantiate(this.node.children[0]);
            this.node.addChild(child);
        }
        for (var i = 0; i < this.node.childrenCount; i++) {
            var child = this.node.children[i];
            //设置进度位置
            child.getComponent(CellItem_1.default).init(0.5 + i / 5, i);
        }
    };
    LoopList.prototype.onEnable = function () {
        this.node.on(cc.Node.EventType.TOUCH_MOVE, this.onTouchMove, this);
    };
    LoopList.prototype.onDisable = function () {
        this.node.off(cc.Node.EventType.TOUCH_MOVE, this.onTouchMove, this);
    };
    LoopList.prototype.onTouchMove = function (event) {
        var delta = event.getDelta().x / this.node.width;
        this.node.children.forEach(function (child) {
            var cell = child.getComponent(CellItem_1.default);
            //因为 cell 受到动画控制，progress 只在0 ~ 1 之间，只要取1的余数就自动循环了，从而避免复杂坐标运算。
            cell.progress = (cell.progress + delta) % 1;
        });
    };
    LoopList = __decorate([
        ccclass
    ], LoopList);
    return LoopList;
}(cc.Component));
exports.default = LoopList;

cc._RF.pop();
                    }
                    if (nodeEnv) {
                        __define(__module.exports, __require, __module);
                    }
                    else {
                        __quick_compile_project__.registerModuleFunc(__filename, function () {
                            __define(__module.exports, __require, __module);
                        });
                    }
                })();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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