"use strict";
cc._RF.push(module, 'a26b2gzKNdNdpyUAAbx+AwQ', 'CellItem');
// CellItem.ts

/*
 * @Author: wss
 * @Date: 2020-03-27 00:38:10
 * @Last Modified by: wss
 * @Last Modified time: 2020-03-27 01:01:53
 */
Object.defineProperty(exports, "__esModule", { value: true });
var _a = cc._decorator, ccclass = _a.ccclass, property = _a.property, executeInEditMode = _a.executeInEditMode;
var CellItem = /** @class */ (function (_super) {
    __extends(CellItem, _super);
    function CellItem() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.anim = null;
        _this.label = null;
        /**
         * 动画完成进度
         */
        _this._progress = 0.5;
        return _this;
    }
    Object.defineProperty(CellItem.prototype, "progress", {
        get: function () {
            return this._progress;
        },
        set: function (v) {
            this._progress = v;
        },
        enumerable: true,
        configurable: true
    });
    CellItem.prototype.onLoad = function () {
        this.anim = this.getComponent(cc.Animation);
        this.anim.play();
    };
    CellItem.prototype.init = function (progress, index) {
        this.progress = progress;
        this.label.string = "(" + index + ")";
    };
    CellItem.prototype.update = function (dt) {
        if (this.anim.currentClip == null)
            return;
        var clip = this.anim.currentClip;
        //[核心部分] 强制设置动画处于某一个时间节点
        this.anim.setCurrentTime(clip.duration * this._progress);
    };
    __decorate([
        property(cc.Animation)
    ], CellItem.prototype, "anim", void 0);
    __decorate([
        property(cc.Label)
    ], CellItem.prototype, "label", void 0);
    __decorate([
        property({
            range: [0, 1],
        })
    ], CellItem.prototype, "_progress", void 0);
    __decorate([
        property({
            range: [0, 1],
            slide: true
        })
    ], CellItem.prototype, "progress", null);
    CellItem = __decorate([
        ccclass
    ], CellItem);
    return CellItem;
}(cc.Component));
exports.default = CellItem;

cc._RF.pop();