"use strict";
cc._RF.push(module, '79c96OmhUNFQL8Aegn+iovc', 'LoopList');
// LoopList.ts

/*
 * @Author: wss
 * @Date: 2020-03-27 00:38:04
 * @Last Modified by: wss
 * @Last Modified time: 2020-03-27 01:03:31
 */
Object.defineProperty(exports, "__esModule", { value: true });
var CellItem_1 = require("./CellItem");
var _a = cc._decorator, ccclass = _a.ccclass, property = _a.property;
var LoopList = /** @class */ (function (_super) {
    __extends(LoopList, _super);
    function LoopList() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    LoopList.prototype.onLoad = function () {
        this.initCells();
    };
    LoopList.prototype.initCells = function () {
        //5个单位
        for (var i = 1; i < 5; i++) {
            var child = cc.instantiate(this.node.children[0]);
            this.node.addChild(child);
        }
        for (var i = 0; i < this.node.childrenCount; i++) {
            var child = this.node.children[i];
            //设置进度位置
            child.getComponent(CellItem_1.default).init(0.5 + i / 5, i);
        }
    };
    LoopList.prototype.onEnable = function () {
        this.node.on(cc.Node.EventType.TOUCH_MOVE, this.onTouchMove, this);
    };
    LoopList.prototype.onDisable = function () {
        this.node.off(cc.Node.EventType.TOUCH_MOVE, this.onTouchMove, this);
    };
    LoopList.prototype.onTouchMove = function (event) {
        var delta = event.getDelta().x / this.node.width;
        this.node.children.forEach(function (child) {
            var cell = child.getComponent(CellItem_1.default);
            //因为 cell 受到动画控制，progress 只在0 ~ 1 之间，只要取1的余数就自动循环了，从而避免复杂坐标运算。
            cell.progress = (cell.progress + delta) % 1;
        });
    };
    LoopList = __decorate([
        ccclass
    ], LoopList);
    return LoopList;
}(cc.Component));
exports.default = LoopList;

cc._RF.pop();